/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.dependencies;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.gson.JsonElement;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import me.lucko.luckperms.common.dependencies.Dependency;
import me.lucko.luckperms.common.dependencies.relocation.Relocation;
import me.lucko.luckperms.common.dependencies.relocation.RelocationHandler;
import me.lucko.luckperms.common.storage.StorageType;
import net.luckperms.api.platform.Platform;

public class DependencyRegistry {
    private static final SetMultimap<StorageType, Dependency> STORAGE_DEPENDENCIES = ImmutableSetMultimap.builder().putAll((Object)StorageType.YAML, (Object[])new Dependency[]{Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_YAML, Dependency.SNAKEYAML}).putAll((Object)StorageType.YAML_COMBINED, (Object[])new Dependency[]{Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_YAML, Dependency.SNAKEYAML}).putAll((Object)StorageType.JSON, (Object[])new Dependency[]{Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_GSON}).putAll((Object)StorageType.JSON_COMBINED, (Object[])new Dependency[]{Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_GSON}).putAll((Object)StorageType.HOCON, (Object[])new Dependency[]{Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_HOCON, Dependency.HOCON_CONFIG}).putAll((Object)StorageType.HOCON_COMBINED, (Object[])new Dependency[]{Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_HOCON, Dependency.HOCON_CONFIG}).putAll((Object)StorageType.TOML, (Object[])new Dependency[]{Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_TOML, Dependency.TOML4J}).putAll((Object)StorageType.TOML_COMBINED, (Object[])new Dependency[]{Dependency.CONFIGURATE_CORE, Dependency.CONFIGURATE_TOML, Dependency.TOML4J}).putAll((Object)StorageType.MONGODB, (Object[])new Dependency[]{Dependency.MONGODB_DRIVER_CORE, Dependency.MONGODB_DRIVER_LEGACY, Dependency.MONGODB_DRIVER_SYNC, Dependency.MONGODB_DRIVER_BSON}).putAll((Object)StorageType.MARIADB, (Object[])new Dependency[]{Dependency.SLF4J_API, Dependency.SLF4J_SIMPLE, Dependency.HIKARI, Dependency.MARIADB_DRIVER}).putAll((Object)StorageType.MYSQL, (Object[])new Dependency[]{Dependency.SLF4J_API, Dependency.SLF4J_SIMPLE, Dependency.HIKARI, Dependency.MYSQL_DRIVER}).putAll((Object)StorageType.POSTGRESQL, (Object[])new Dependency[]{Dependency.SLF4J_API, Dependency.SLF4J_SIMPLE, Dependency.HIKARI, Dependency.POSTGRESQL_DRIVER}).putAll((Object)StorageType.SQLITE, (Object[])new Dependency[]{Dependency.SQLITE_DRIVER}).putAll((Object)StorageType.H2, (Object[])new Dependency[]{Dependency.H2_DRIVER}).build();
    private static final Set<Platform.Type> SNAKEYAML_PROVIDED_BY_PLATFORM = ImmutableSet.of((Object)((Object)Platform.Type.BUKKIT), (Object)((Object)Platform.Type.BUNGEECORD), (Object)((Object)Platform.Type.SPONGE), (Object)((Object)Platform.Type.NUKKIT));
    private final Platform.Type platformType;

    public DependencyRegistry(Platform.Type platformType) {
        this.platformType = platformType;
    }

    public Set<Dependency> resolveStorageDependencies(Set<StorageType> storageTypes, boolean redis, boolean rabbitmq, boolean nats) {
        LinkedHashSet<Dependency> dependencies = new LinkedHashSet<Dependency>();
        for (StorageType storageType : storageTypes) {
            dependencies.addAll(STORAGE_DEPENDENCIES.get((Object)storageType));
        }
        if (redis) {
            dependencies.add(Dependency.COMMONS_POOL_2);
            dependencies.add(Dependency.JEDIS);
            dependencies.add(Dependency.SLF4J_API);
            dependencies.add(Dependency.SLF4J_SIMPLE);
        }
        if (nats) {
            dependencies.add(Dependency.NATS);
        }
        if (rabbitmq) {
            dependencies.add(Dependency.RABBITMQ);
        }
        if ((dependencies.contains((Object)Dependency.SLF4J_API) || dependencies.contains((Object)Dependency.SLF4J_SIMPLE)) && DependencyRegistry.slf4jPresent()) {
            dependencies.remove((Object)Dependency.SLF4J_API);
            dependencies.remove((Object)Dependency.SLF4J_SIMPLE);
        }
        if (dependencies.contains((Object)Dependency.SNAKEYAML) && SNAKEYAML_PROVIDED_BY_PLATFORM.contains((Object)this.platformType)) {
            dependencies.remove((Object)Dependency.SNAKEYAML);
        }
        return dependencies;
    }

    public void applyRelocationSettings(Dependency dependency, List<Relocation> relocations) {
        if (!RelocationHandler.DEPENDENCIES.contains((Object)dependency) && DependencyRegistry.isGsonRelocated()) {
            relocations.add(Relocation.of("guava", "com{}google{}common"));
            relocations.add(Relocation.of("gson", "com{}google{}gson"));
        }
        if (dependency == Dependency.CONFIGURATE_YAML && !SNAKEYAML_PROVIDED_BY_PLATFORM.contains((Object)this.platformType)) {
            relocations.add(Relocation.of("yaml", "org{}yaml{}snakeyaml"));
        }
    }

    public boolean shouldAutoLoad(Dependency dependency) {
        switch (dependency) {
            case ASM: 
            case ASM_COMMONS: 
            case JAR_RELOCATOR: 
            case H2_DRIVER: 
            case H2_DRIVER_LEGACY: 
            case SQLITE_DRIVER: {
                return false;
            }
        }
        return true;
    }

    public static boolean isGsonRelocated() {
        return JsonElement.class.getName().startsWith("me.lucko");
    }

    private static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean slf4jPresent() {
        return DependencyRegistry.classExists("org.slf4j.Logger") && DependencyRegistry.classExists("org.slf4j.LoggerFactory");
    }
}

