/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.filter;

import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import me.lucko.luckperms.common.filter.Comparison;
import me.lucko.luckperms.common.filter.Constraint;

public interface ConstraintFactory<T> {
    public static final ConstraintFactory<String> STRINGS = new ConstraintFactory<String>(){

        @Override
        public Predicate<String> equal(String value) {
            return value::equalsIgnoreCase;
        }

        @Override
        public Predicate<String> notEqual(String value) {
            return string -> !value.equalsIgnoreCase((String)string);
        }

        @Override
        public Predicate<String> similar(String value) {
            Pattern pattern = Comparison.compilePatternForLikeSyntax(value);
            return string -> pattern.matcher((CharSequence)string).matches();
        }

        @Override
        public Predicate<String> notSimilar(String value) {
            Pattern pattern = Comparison.compilePatternForLikeSyntax(value);
            return string -> !pattern.matcher((CharSequence)string).matches();
        }
    };
    public static final ConstraintFactory<UUID> UUIDS = new ConstraintFactory<UUID>(){

        @Override
        public Predicate<UUID> equal(UUID value) {
            return value::equals;
        }

        @Override
        public Predicate<UUID> notEqual(UUID value) {
            return string -> !value.equals(string);
        }

        @Override
        public Predicate<UUID> similar(UUID value) {
            Pattern pattern = Comparison.compilePatternForLikeSyntax(value.toString());
            return uuid -> pattern.matcher(uuid.toString()).matches();
        }

        @Override
        public Predicate<UUID> notSimilar(UUID value) {
            Pattern pattern = Comparison.compilePatternForLikeSyntax(value.toString());
            return uuid -> !pattern.matcher(uuid.toString()).matches();
        }
    };

    public Predicate<T> equal(T var1);

    public Predicate<T> notEqual(T var1);

    public Predicate<T> similar(T var1);

    public Predicate<T> notSimilar(T var1);

    default public Constraint<T> build(Comparison comparison, T value) {
        switch (comparison) {
            case EQUAL: {
                return new Constraint<T>(comparison, value, this.equal(value));
            }
            case NOT_EQUAL: {
                return new Constraint<T>(comparison, value, this.notEqual(value));
            }
            case SIMILAR: {
                return new Constraint<T>(comparison, value, this.similar(value));
            }
            case NOT_SIMILAR: {
                return new Constraint<T>(comparison, value, this.notSimilar(value));
            }
        }
        throw new AssertionError((Object)comparison);
    }
}

