/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import com.google.common.collect.Iterables;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import me.lucko.luckperms.common.cacheddata.HolderCachedDataManager;
import me.lucko.luckperms.common.cacheddata.result.IntegerResult;
import me.lucko.luckperms.common.cacheddata.type.MetaAccumulator;
import me.lucko.luckperms.common.inheritance.InheritanceComparator;
import me.lucko.luckperms.common.inheritance.InheritanceGraph;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolderIdentifier;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.model.nodemap.NodeMap;
import me.lucko.luckperms.common.model.nodemap.NodeMapMutable;
import me.lucko.luckperms.common.model.nodemap.RecordedNodeMap;
import me.lucko.luckperms.common.node.NodeEquality;
import me.lucko.luckperms.common.node.comparator.NodeWithContextComparator;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.query.DataSelector;
import me.lucko.luckperms.common.util.Difference;
import me.lucko.luckperms.lib.adventure.text.Component;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.model.data.TemporaryNodeMergeStrategy;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeEqualityPredicate;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.node.types.WeightNode;
import net.luckperms.api.query.Flag;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.util.Tristate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PermissionHolder {
    private final LuckPermsPlugin plugin;
    private final PermissionHolderIdentifier identifier;
    private final RecordedNodeMap normalNodes;
    private final NodeMap transientNodes;
    private final Comparator<? super PermissionHolder> inheritanceComparator;

    protected PermissionHolder(LuckPermsPlugin plugin, String objectName) {
        this.plugin = plugin;
        this.identifier = new PermissionHolderIdentifier(this.getType(), objectName);
        this.normalNodes = new RecordedNodeMap(new NodeMapMutable(this, DataType.NORMAL));
        this.transientNodes = new NodeMapMutable(this, DataType.TRANSIENT);
        this.inheritanceComparator = InheritanceComparator.getFor(this);
    }

    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    public Comparator<? super PermissionHolder> getInheritanceComparator() {
        return this.inheritanceComparator;
    }

    public NodeMap getData(DataType type) {
        switch (type) {
            case NORMAL: {
                return this.normalNodes;
            }
            case TRANSIENT: {
                return this.transientNodes;
            }
        }
        throw new AssertionError();
    }

    public RecordedNodeMap normalData() {
        return this.normalNodes;
    }

    public NodeMap transientData() {
        return this.transientNodes;
    }

    public PermissionHolderIdentifier getIdentifier() {
        return this.identifier;
    }

    public abstract Component getFormattedDisplayName();

    public abstract String getPlainDisplayName();

    public abstract QueryOptions getQueryOptions();

    public abstract HolderCachedDataManager<?> getCachedData();

    public abstract HolderType getType();

    protected void invalidateCache() {
        this.getCachedData().invalidate();
        this.getPlugin().getEventDispatcher().dispatchDataRecalculate(this);
    }

    public void loadNodesFromStorage(Iterable<? extends Node> set) {
        this.normalData().discardChanges();
        this.normalData().bypass().setContent(set);
        this.invalidateCache();
    }

    public Difference<Node> setNodes(DataType type, Iterable<? extends Node> set, boolean callEvent) {
        Difference<Node> res = this.getData(type).setContent(set);
        this.invalidateCache();
        if (callEvent) {
            this.getPlugin().getEventDispatcher().dispatchNodeChanges(this, type, res);
        }
        return res;
    }

    public Difference<Node> setNodes(DataType type, Difference<Node> changes, boolean callEvent) {
        Difference<Node> res = this.getData(type).applyChanges(changes);
        this.invalidateCache();
        if (callEvent) {
            this.getPlugin().getEventDispatcher().dispatchNodeChanges(this, type, res);
        }
        return res;
    }

    public void mergeNodes(DataType type, Iterable<? extends Node> set) {
        this.getData(type).addAll(set);
        this.invalidateCache();
    }

    private DataType[] queryOrder(QueryOptions queryOptions) {
        return DataSelector.selectOrder(queryOptions, this.getIdentifier());
    }

    public List<Node> getOwnNodes(QueryOptions queryOptions) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (DataType dataType : this.queryOrder(queryOptions)) {
            this.getData(dataType).copyTo(nodes, queryOptions);
        }
        return nodes;
    }

    public SortedSet<Node> getOwnNodesSorted(QueryOptions queryOptions) {
        TreeSet<Node> nodes = new TreeSet<Node>(NodeWithContextComparator.reverse());
        for (DataType dataType : this.queryOrder(queryOptions)) {
            this.getData(dataType).copyTo(nodes, queryOptions);
        }
        return nodes;
    }

    public <T extends Node> List<T> getOwnNodes(NodeType<T> type, QueryOptions queryOptions) {
        ArrayList nodes = new ArrayList();
        for (DataType dataType : this.queryOrder(queryOptions)) {
            this.getData(dataType).copyTo(nodes, type, queryOptions);
        }
        return nodes;
    }

    public List<InheritanceNode> getOwnInheritanceNodes(QueryOptions queryOptions) {
        ArrayList<InheritanceNode> nodes = new ArrayList<InheritanceNode>();
        for (DataType dataType : this.queryOrder(queryOptions)) {
            this.getData(dataType).copyInheritanceNodesTo(nodes, queryOptions);
        }
        return nodes;
    }

    public List<Node> resolveInheritedNodes(QueryOptions queryOptions) {
        if (!queryOptions.flag(Flag.RESOLVE_INHERITANCE)) {
            return this.getOwnNodes(queryOptions);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        InheritanceGraph graph = this.plugin.getInheritanceGraphFactory().getGraph(queryOptions);
        for (PermissionHolder holder : graph.traverse(this)) {
            for (DataType dataType : holder.queryOrder(queryOptions)) {
                holder.getData(dataType).copyTo(nodes, queryOptions);
            }
        }
        return nodes;
    }

    public SortedSet<Node> resolveInheritedNodesSorted(QueryOptions queryOptions) {
        if (!queryOptions.flag(Flag.RESOLVE_INHERITANCE)) {
            return this.getOwnNodesSorted(queryOptions);
        }
        TreeSet<Node> nodes = new TreeSet<Node>(NodeWithContextComparator.reverse());
        InheritanceGraph graph = this.plugin.getInheritanceGraphFactory().getGraph(queryOptions);
        for (PermissionHolder holder : graph.traverse(this)) {
            for (DataType dataType : holder.queryOrder(queryOptions)) {
                holder.getData(dataType).copyTo(nodes, queryOptions);
            }
        }
        return nodes;
    }

    public <T extends Node> List<T> resolveInheritedNodes(NodeType<T> type, QueryOptions queryOptions) {
        if (!queryOptions.flag(Flag.RESOLVE_INHERITANCE)) {
            return this.getOwnNodes(type, queryOptions);
        }
        ArrayList nodes = new ArrayList();
        InheritanceGraph graph = this.plugin.getInheritanceGraphFactory().getGraph(queryOptions);
        for (PermissionHolder holder : graph.traverse(this)) {
            for (DataType dataType : holder.queryOrder(queryOptions)) {
                holder.getData(dataType).copyTo(nodes, type, queryOptions);
            }
        }
        return nodes;
    }

    public List<Group> resolveInheritanceTree(QueryOptions queryOptions) {
        InheritanceGraph graph = this.plugin.getInheritanceGraphFactory().getGraph(queryOptions);
        ArrayList<Group> inheritanceTree = new ArrayList<Group>();
        if (queryOptions.flag(Flag.RESOLVE_INHERITANCE)) {
            Iterables.addAll(inheritanceTree, graph.traverse(this));
            inheritanceTree.remove(this);
        } else {
            Iterables.addAll(inheritanceTree, graph.successors(this));
        }
        for (PermissionHolder permissionHolder : inheritanceTree) {
            if (permissionHolder instanceof Group) continue;
            throw new IllegalStateException("Non-group object in inheritance tree: " + String.valueOf(permissionHolder));
        }
        return inheritanceTree;
    }

    public <M extends Map<String, Node>> M exportPermissions(IntFunction<M> mapFactory, QueryOptions queryOptions, boolean convertToLowercase, boolean resolveShorthand) {
        List<Node> entries = this.resolveInheritedNodes(queryOptions);
        Map map = (Map)mapFactory.apply(entries.size());
        PermissionHolder.processExportedPermissions(map, entries, convertToLowercase, resolveShorthand);
        return (M)map;
    }

    private static void processExportedPermissions(Map<String, Node> accumulator, List<Node> entries, boolean convertToLowercase, boolean resolveShorthand) {
        for (Node node : entries) {
            if (convertToLowercase) {
                accumulator.putIfAbsent(node.getKey().toLowerCase(Locale.ROOT), node);
                continue;
            }
            accumulator.putIfAbsent(node.getKey(), node);
        }
        if (resolveShorthand) {
            for (Node node : entries) {
                Collection<String> shorthand = node.resolveShorthand();
                for (String s : shorthand) {
                    if (convertToLowercase) {
                        accumulator.putIfAbsent(s.toLowerCase(Locale.ROOT), node);
                        continue;
                    }
                    accumulator.putIfAbsent(s, node);
                }
            }
        }
    }

    public MetaAccumulator accumulateMeta(QueryOptions queryOptions) {
        return this.accumulateMeta(MetaAccumulator.makeFromConfig(this.plugin), queryOptions);
    }

    public MetaAccumulator accumulateMeta(MetaAccumulator accumulator, QueryOptions queryOptions) {
        InheritanceGraph graph = this.plugin.getInheritanceGraphFactory().getGraph(queryOptions);
        for (PermissionHolder holder : graph.traverse(this)) {
            for (DataType dataType : holder.queryOrder(queryOptions)) {
                holder.getData(dataType).forEach(queryOptions, node -> {
                    if (NodeType.META_OR_CHAT_META.matches((Node)node)) {
                        accumulator.accumulateNode((Node)node);
                    }
                });
            }
            IntegerResult<WeightNode> weight = holder.getWeightResult();
            if (weight.isNull()) continue;
            accumulator.accumulateWeight(weight);
        }
        if (this instanceof User) {
            String primaryGroup = ((User)this).getPrimaryGroup().calculateValue(queryOptions);
            accumulator.setPrimaryGroup(primaryGroup);
        }
        accumulator.complete();
        return accumulator;
    }

    public boolean auditTemporaryNodes() {
        boolean transientWork = this.auditTemporaryNodes(DataType.TRANSIENT);
        boolean normalWork = this.auditTemporaryNodes(DataType.NORMAL);
        return transientWork || normalWork;
    }

    private boolean auditTemporaryNodes(DataType dataType) {
        Difference<Node> result = this.getData(dataType).removeIf(Node::hasExpired);
        if (!result.isEmpty()) {
            this.invalidateCache();
            this.plugin.getEventDispatcher().dispatchNodeChanges(this, dataType, result);
        }
        return !result.isEmpty();
    }

    public Tristate hasNode(DataType type, Node node, NodeEqualityPredicate equalityPredicate) {
        if (this.getType() == HolderType.GROUP && node instanceof InheritanceNode && ((InheritanceNode)node).getGroupName().equalsIgnoreCase(this.getIdentifier().getName())) {
            return Tristate.TRUE;
        }
        Collection<Node> nodes = NodeEquality.comparesContexts(equalityPredicate) ? this.getData(type).nodesInContext(node.getContexts()) : this.getData(type).asList();
        for (Node other : nodes) {
            if (!equalityPredicate.areEqual(node, other)) continue;
            return Tristate.of(other.getValue());
        }
        return Tristate.UNDEFINED;
    }

    public DataMutateResult setNode(DataType dataType, Node node, boolean callEvent) {
        if (this.hasNode(dataType, node, NodeEqualityPredicate.IGNORE_EXPIRY_TIME) != Tristate.UNDEFINED) {
            return DataMutateResult.FAIL_ALREADY_HAS;
        }
        Difference<Node> changes = this.getData(dataType).add(node);
        this.invalidateCache();
        if (callEvent) {
            this.plugin.getEventDispatcher().dispatchNodeChanges(this, dataType, changes);
        }
        return DataMutateResult.SUCCESS;
    }

    public DataMutateResult.WithMergedNode setNode(DataType dataType, Node node, TemporaryNodeMergeStrategy mergeStrategy) {
        Node otherMatch;
        if (node.getExpiry() != null && mergeStrategy != TemporaryNodeMergeStrategy.NONE && (otherMatch = (Node)this.getData(dataType).nodesInContext(node.getContexts()).stream().filter(NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE.equalTo(node)).findFirst().orElse(null)) != null && otherMatch.getExpiry() != null) {
            NodeMap data = this.getData(dataType);
            Node newNode = null;
            switch (mergeStrategy) {
                case ADD_NEW_DURATION_TO_EXISTING: {
                    Instant newExpiry = otherMatch.getExpiry().plus(Duration.between(Instant.now(), node.getExpiry()));
                    newNode = node.toBuilder().expiry(newExpiry).build();
                    break;
                }
                case REPLACE_EXISTING_IF_DURATION_LONGER: {
                    if (node.getExpiry().compareTo(otherMatch.getExpiry()) <= 0) break;
                    newNode = node;
                }
            }
            if (newNode != null) {
                Difference<Node> changes = data.removeThenAdd(otherMatch, newNode);
                this.invalidateCache();
                this.plugin.getEventDispatcher().dispatchNodeChanges(this, dataType, changes);
                return new MergedNodeResult(DataMutateResult.SUCCESS, newNode);
            }
        }
        return new MergedNodeResult(this.setNode(dataType, node, true), node);
    }

    public DataMutateResult unsetNode(DataType dataType, Node node) {
        if (this.hasNode(dataType, node, NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE) == Tristate.UNDEFINED) {
            return DataMutateResult.FAIL_LACKS;
        }
        Difference<Node> changes = this.getData(dataType).remove(node);
        this.invalidateCache();
        this.plugin.getEventDispatcher().dispatchNodeChanges(this, dataType, changes);
        return DataMutateResult.SUCCESS;
    }

    public DataMutateResult.WithMergedNode unsetNode(DataType dataType, Node node, @Nullable Duration duration) {
        Node otherMatch;
        if (node.getExpiry() != null && duration != null && (otherMatch = (Node)this.getData(dataType).nodesInContext(node.getContexts()).stream().filter(NodeEqualityPredicate.IGNORE_EXPIRY_TIME_AND_VALUE.equalTo(node)).findFirst().orElse(null)) != null && otherMatch.getExpiry() != null) {
            NodeMap data = this.getData(dataType);
            Instant newExpiry = otherMatch.getExpiry().minus(duration);
            if (newExpiry.isAfter(Instant.now())) {
                Object newNode = node.toBuilder().expiry(newExpiry).build();
                Difference<Node> changes = data.removeThenAdd(otherMatch, (Node)newNode);
                this.invalidateCache();
                this.plugin.getEventDispatcher().dispatchNodeChanges(this, dataType, changes);
                return new MergedNodeResult(DataMutateResult.SUCCESS, (Node)newNode);
            }
        }
        return new MergedNodeResult(this.unsetNode(dataType, node), null);
    }

    public boolean removeIf(DataType dataType, @Nullable ContextSet contextSet, Predicate<? super Node> predicate, boolean giveDefault) {
        Difference<Node> changes = contextSet == null ? this.getData(dataType).removeIf(predicate) : this.getData(dataType).removeIf(contextSet, predicate);
        if (changes.isEmpty()) {
            return false;
        }
        if (this.getType() == HolderType.USER && giveDefault) {
            this.getPlugin().getUserManager().giveDefaultIfNeeded((User)this);
        }
        this.invalidateCache();
        this.plugin.getEventDispatcher().dispatchNodeClear(this, dataType, changes);
        return true;
    }

    public boolean clearNodes(DataType dataType, ContextSet contextSet, boolean giveDefault) {
        Difference<Node> changes = contextSet == null ? this.getData(dataType).clear() : this.getData(dataType).clear(contextSet);
        if (this.getType() == HolderType.USER && giveDefault) {
            this.getPlugin().getUserManager().giveDefaultIfNeeded((User)this);
        }
        this.invalidateCache();
        this.plugin.getEventDispatcher().dispatchNodeClear(this, dataType, changes);
        return true;
    }

    public IntegerResult<WeightNode> getWeightResult() {
        return IntegerResult.nullResult();
    }

    public OptionalInt getWeight() {
        IntegerResult<WeightNode> result = this.getWeightResult();
        return result.isNull() ? OptionalInt.empty() : OptionalInt.of(result.intResult());
    }

    private static final class MergedNodeResult
    implements DataMutateResult.WithMergedNode {
        private final DataMutateResult result;
        private final Node mergedNode;

        private MergedNodeResult(DataMutateResult result, Node mergedNode) {
            this.result = result;
            this.mergedNode = mergedNode;
        }

        @Override
        public @NonNull DataMutateResult getResult() {
            return this.result;
        }

        @Override
        public @NonNull Node getMergedNode() {
            return this.mergedNode;
        }
    }
}

