/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.matcher;

import me.lucko.luckperms.common.filter.Comparison;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.node.types.DisplayName;
import me.lucko.luckperms.common.node.types.Inheritance;
import me.lucko.luckperms.common.node.types.Meta;
import me.lucko.luckperms.common.node.types.RegexPermission;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeEqualityPredicate;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.MetaNode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StandardNodeMatchers {
    private StandardNodeMatchers() {
    }

    public static ConstraintNodeMatcher<Node> key(String value, Comparison comparison) {
        return new Generic(comparison, value);
    }

    public static ConstraintNodeMatcher<Node> key(String key) {
        return new Generic(Comparison.EQUAL, key);
    }

    public static <T extends Node> ConstraintNodeMatcher<T> key(T node) {
        return new NodeEquals<T>(node, NodeEqualityPredicate.ONLY_KEY);
    }

    public static ConstraintNodeMatcher<Node> keyStartsWith(String startsWith) {
        return new Generic(Comparison.SIMILAR, startsWith + "%");
    }

    public static <T extends Node> ConstraintNodeMatcher<T> equals(T other, NodeEqualityPredicate equalityPredicate) {
        return new NodeEquals<T>(other, equalityPredicate);
    }

    public static ConstraintNodeMatcher<MetaNode> metaKey(String metaKey) {
        return new MetaKeyEquals(metaKey);
    }

    public static <T extends Node> ConstraintNodeMatcher<T> type(NodeType<? extends T> type) {
        return new TypeEquals<T>(type);
    }

    public static class Generic
    extends ConstraintNodeMatcher<Node> {
        Generic(Comparison comparison, String value) {
            super(comparison, value);
        }

        @Override
        public @Nullable Node filterConstraintMatch(@NonNull Node node) {
            return node;
        }
    }

    public static final class NodeEquals<T extends Node>
    extends ConstraintNodeMatcher<T> {
        private final T node;
        private final NodeEqualityPredicate equalityPredicate;

        NodeEquals(T node, NodeEqualityPredicate equalityPredicate) {
            super(Comparison.EQUAL, node.getKey());
            this.node = node;
            this.equalityPredicate = equalityPredicate;
        }

        public T getNode() {
            return this.node;
        }

        public NodeEqualityPredicate getEqualityPredicate() {
            return this.equalityPredicate;
        }

        @Override
        public @Nullable T filterConstraintMatch(@NonNull Node node) {
            if (this.equalityPredicate == NodeEqualityPredicate.ONLY_KEY || this.node.equals(node, this.equalityPredicate)) {
                return (T)node;
            }
            return null;
        }
    }

    public static final class MetaKeyEquals
    extends ConstraintNodeMatcher<MetaNode> {
        private final String metaKey;

        MetaKeyEquals(String metaKey) {
            super(Comparison.SIMILAR, Meta.key(metaKey, "%"));
            this.metaKey = metaKey;
        }

        public String getMetaKey() {
            return this.metaKey;
        }

        @Override
        public @Nullable MetaNode filterConstraintMatch(@NonNull Node node) {
            return NodeType.META.tryCast(node).orElse(null);
        }
    }

    public static final class TypeEquals<T extends Node>
    extends ConstraintNodeMatcher<T> {
        private final NodeType<? extends T> type;

        TypeEquals(NodeType<? extends T> type) {
            super(Comparison.SIMILAR, TypeEquals.getSimilarToComparisonValue(type));
            this.type = type;
        }

        public NodeType<? extends T> getType() {
            return this.type;
        }

        @Override
        public @Nullable T filterConstraintMatch(@NonNull Node node) {
            return (T)((Node)this.type.tryCast(node).orElse(null));
        }

        private static String getSimilarToComparisonValue(NodeType<?> type) {
            if (type == NodeType.REGEX_PERMISSION) {
                return RegexPermission.key("%");
            }
            if (type == NodeType.INHERITANCE) {
                return Inheritance.key("%");
            }
            if (type == NodeType.PREFIX) {
                return "prefix.%.%";
            }
            if (type == NodeType.SUFFIX) {
                return "suffix.%.%";
            }
            if (type == NodeType.META) {
                return Meta.key("%", "%");
            }
            if (type == NodeType.WEIGHT) {
                return "weight.%";
            }
            if (type == NodeType.DISPLAY_NAME) {
                return DisplayName.key("%");
            }
            throw new IllegalArgumentException("Unable to create a NodeMatcher for NodeType " + type.name());
        }
    }
}

