/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage;

import com.google.common.collect.ImmutableList;
import java.util.List;

public enum StorageType {
    YAML("YAML", "yaml", "yml"),
    JSON("JSON", "json", "flatfile"),
    HOCON("HOCON", "hocon"),
    TOML("TOML", "toml"),
    YAML_COMBINED("YAML Combined", "yaml-combined"),
    JSON_COMBINED("JSON Combined", "json-combined"),
    HOCON_COMBINED("HOCON Combined", "hocon-combined"),
    TOML_COMBINED("TOML Combined", "toml-combined"),
    MONGODB("MongoDB", "mongodb"),
    MARIADB("MariaDB", "mariadb"),
    MYSQL("MySQL", "mysql"),
    POSTGRESQL("PostgreSQL", "postgresql"),
    SQLITE("SQLite", "sqlite"),
    H2("H2", "h2"),
    REST("REST", "rest"),
    CUSTOM("Custom", "custom");

    private final String name;
    private final List<String> identifiers;

    private StorageType(String name, String ... identifiers) {
        this.name = name;
        this.identifiers = ImmutableList.copyOf((Object[])identifiers);
    }

    public static StorageType parse(String name, StorageType def) {
        for (StorageType t : StorageType.values()) {
            for (String id : t.getIdentifiers()) {
                if (!id.equalsIgnoreCase(name)) continue;
                return t;
            }
        }
        return def;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getIdentifiers() {
        return this.identifiers;
    }
}

