/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.treeview;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerAdapter;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerTask;
import me.lucko.luckperms.common.treeview.PermissionRegistry;

public class AsyncPermissionRegistry
extends PermissionRegistry
implements AutoCloseable {
    private final Queue<String> queue = new ConcurrentLinkedQueue<String>();
    private final SchedulerTask task;

    public AsyncPermissionRegistry(SchedulerAdapter scheduler) {
        this.task = scheduler.asyncRepeating(this::tick, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void offer(String permission) {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        this.queue.offer(permission);
    }

    private void tick() {
        String e;
        while ((e = this.queue.poll()) != null) {
            try {
                this.doInsert(e);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void close() {
        this.task.cancel();
    }
}

