/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;
import me.lucko.luckperms.common.cacheddata.result.StringResult;
import me.lucko.luckperms.common.cacheddata.result.TristateResult;
import me.lucko.luckperms.common.http.AbstractHttpClient;
import me.lucko.luckperms.common.http.BytebinClient;
import me.lucko.luckperms.common.http.UnsuccessfulRequestException;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.DurationFormatter;
import me.lucko.luckperms.common.util.StackTracePrinter;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import me.lucko.luckperms.common.util.gson.JArray;
import me.lucko.luckperms.common.util.gson.JObject;
import me.lucko.luckperms.common.verbose.VerboseFilter;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import me.lucko.luckperms.common.verbose.event.MetaCheckEvent;
import me.lucko.luckperms.common.verbose.event.PermissionCheckEvent;
import me.lucko.luckperms.common.verbose.event.VerboseEvent;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.JoinConfiguration;
import me.lucko.luckperms.lib.adventure.text.event.HoverEvent;
import me.lucko.luckperms.lib.adventure.text.event.HoverEventSource;
import net.luckperms.api.cacheddata.Result;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.query.QueryMode;

public class VerboseListener {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z").withZone(ZoneId.systemDefault());
    private static final int DATA_TRUNCATION = 10000;
    private static final int STACK_TRUNCATION_CHAT = 15;
    private static final int STACK_TRUNCATION_WEB = 40;
    private static final StackTracePrinter FILTERING_PRINTER = StackTracePrinter.builder().ignoreClassStartingWith("me.lucko.luckperms.").ignoreClass("java.util.concurrent.CompletableFuture").ignoreClass("java.util.concurrent.ConcurrentHashMap").build();
    private static final StackTracePrinter CHAT_FILTERED_PRINTER = FILTERING_PRINTER.toBuilder().truncateLength(15).build();
    private static final StackTracePrinter CHAT_UNFILTERED_PRINTER = StackTracePrinter.builder().truncateLength(15).build();
    private static final StackTracePrinter WEB_FILTERED_PRINTER = FILTERING_PRINTER.toBuilder().truncateLength(40).build();
    private static final StackTracePrinter WEB_UNFILTERED_PRINTER = StackTracePrinter.builder().truncateLength(40).build();
    private final Instant startTime = Instant.now();
    private final Sender notifiedSender;
    private final VerboseFilter filter;
    private final boolean notify;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final AtomicInteger matchedCounter = new AtomicInteger(0);
    private final List<VerboseEvent> results = new ArrayList<VerboseEvent>(1000);

    public VerboseListener(Sender notifiedSender, VerboseFilter filter, boolean notify) {
        this.notifiedSender = notifiedSender;
        this.filter = filter;
        this.notify = notify;
    }

    public void acceptEvent(VerboseEvent event) {
        this.counter.incrementAndGet();
        if (!this.filter.evaluate(event)) {
            return;
        }
        this.matchedCounter.incrementAndGet();
        if (this.results.size() < 10000) {
            this.results.add(event);
        }
        if (this.notify) {
            this.sendNotification(event);
        }
    }

    private void sendNotification(VerboseEvent event) {
        Object node;
        TristateResult tristateResult;
        Component component;
        if (event instanceof PermissionCheckEvent) {
            PermissionCheckEvent permissionEvent = (PermissionCheckEvent)event;
            component = Message.VERBOSE_LOG_PERMISSION.build(permissionEvent.getCheckTarget().describe(), permissionEvent.getPermission(), permissionEvent.getResult().result());
        } else if (event instanceof MetaCheckEvent) {
            MetaCheckEvent metaEvent = (MetaCheckEvent)event;
            component = Message.VERBOSE_LOG_META.build(metaEvent.getCheckTarget().describe(), metaEvent.getKey(), String.valueOf(((StringResult)metaEvent.getResult()).result()));
        } else {
            throw new IllegalArgumentException("Unknown event type: " + String.valueOf(event));
        }
        if (this.notifiedSender.isConsole()) {
            this.notifiedSender.sendMessage(component);
            return;
        }
        ArrayList<Component> hover = new ArrayList<Component>();
        hover.add(Message.VERBOSE_LOG_HOVER_TYPE.build(event.getType().toString()));
        hover.add(Message.VERBOSE_LOG_HOVER_ORIGIN.build(event.getOrigin().name()));
        Result<?, ?> result = event.getResult();
        if (result instanceof TristateResult && (tristateResult = (TristateResult)result).processorClass() != null) {
            hover.add(Message.VERBOSE_LOG_HOVER_PROCESSOR.build(tristateResult.processorClassFriendly()));
        }
        if ((node = result.node()) != null) {
            if (node instanceof MetaNode) {
                hover.add(Message.VERBOSE_LOG_HOVER_CAUSE_META.build((MetaNode)node));
            } else {
                hover.add(Message.VERBOSE_LOG_HOVER_CAUSE.build((Node)node));
            }
        }
        if (event.getCheckQueryOptions().mode() == QueryMode.CONTEXTUAL) {
            hover.add(Message.VERBOSE_LOG_HOVER_CONTEXT.build(event.getCheckQueryOptions().context()));
        }
        hover.add(Message.VERBOSE_LOG_HOVER_THREAD.build(event.getCheckThread()));
        hover.add(Message.VERBOSE_LOG_HOVER_TRACE_TITLE.build());
        Consumer<StackTraceElement> printer = StackTracePrinter.elementToString(str -> hover.add(Message.VERBOSE_LOG_HOVER_TRACE_CONTENT.build((String)str)));
        int overflow = VerboseListener.shouldFilterStackTrace(event) ? CHAT_FILTERED_PRINTER.process(event.getCheckTrace(), printer) : CHAT_UNFILTERED_PRINTER.process(event.getCheckTrace(), printer);
        if (overflow != 0) {
            hover.add(Message.VERBOSE_LOG_HOVER_TRACE_OVERFLOW.build(overflow));
        }
        HoverEvent hoverEvent = HoverEvent.showText((Component)Component.join((JoinConfiguration)JoinConfiguration.newlines(), hover));
        this.notifiedSender.sendMessage(component.hoverEvent((HoverEventSource)hoverEvent));
    }

    private static boolean shouldFilterStackTrace(VerboseEvent event) {
        if (event instanceof PermissionCheckEvent) {
            PermissionCheckEvent permissionEvent = (PermissionCheckEvent)event;
            return permissionEvent.getOrigin() == CheckOrigin.PLATFORM_API_HAS_PERMISSION_SET || permissionEvent.getOrigin() == CheckOrigin.PLATFORM_API_HAS_PERMISSION;
        }
        return false;
    }

    public String uploadPasteData(BytebinClient bytebin) throws IOException, UnsuccessfulRequestException {
        String startDate = DATE_FORMAT.format(this.startTime);
        String endDate = DATE_FORMAT.format(Instant.now());
        String duration = DurationFormatter.CONCISE.formatString(Duration.between(this.startTime, Instant.now()));
        boolean truncated = this.matchedCounter.get() > this.results.size();
        JObject metadata = new JObject().add("startTime", startDate).add("endTime", endDate).add("duration", duration).add("count", new JObject().add("matched", this.matchedCounter.get()).add("total", this.counter.get())).add("uploader", new JObject().add("name", this.notifiedSender.getNameWithLocation()).add("uuid", this.notifiedSender.getUniqueId().toString())).add("filter", this.filter.toString()).add("truncated", truncated);
        JArray data = new JArray();
        for (VerboseEvent event : this.results) {
            data.add((JsonElement)event.toJson(VerboseListener.shouldFilterStackTrace(event) ? WEB_FILTERED_PRINTER : WEB_UNFILTERED_PRINTER));
        }
        this.results.clear();
        JsonObject payload = new JObject().add("metadata", metadata).add("data", data).toJson();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(bytesOut), StandardCharsets.UTF_8);){
            GsonProvider.normal().toJson((JsonElement)payload, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytebin.postContent(bytesOut.toByteArray(), AbstractHttpClient.JSON_TYPE).key();
    }

    public Sender getNotifiedSender() {
        return this.notifiedSender;
    }

    public int getMatchedCount() {
        return this.matchedCounter.get();
    }
}

