/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.fabric;

import java.util.ArrayList;
import me.lucko.luckperms.common.cacheddata.CacheMetadata;
import me.lucko.luckperms.common.calculator.CalculatorFactory;
import me.lucko.luckperms.common.calculator.PermissionCalculator;
import me.lucko.luckperms.common.calculator.processor.DirectProcessor;
import me.lucko.luckperms.common.calculator.processor.PermissionProcessor;
import me.lucko.luckperms.common.calculator.processor.RegexProcessor;
import me.lucko.luckperms.common.calculator.processor.SpongeWildcardProcessor;
import me.lucko.luckperms.common.calculator.processor.WildcardProcessor;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.fabric.LPFabricPlugin;
import me.lucko.luckperms.fabric.calculator.ServerOwnerProcessor;
import me.lucko.luckperms.fabric.context.FabricContextManager;
import net.luckperms.api.query.QueryOptions;

public class FabricCalculatorFactory
implements CalculatorFactory {
    private final LPFabricPlugin plugin;

    public FabricCalculatorFactory(LPFabricPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public PermissionCalculator build(QueryOptions queryOptions, CacheMetadata metadata) {
        boolean integratedOwner;
        ArrayList<PermissionProcessor> processors = new ArrayList<PermissionProcessor>(5);
        processors.add(new DirectProcessor());
        if (this.plugin.getConfiguration().get(ConfigKeys.APPLYING_REGEX).booleanValue()) {
            processors.add(new RegexProcessor());
        }
        if (this.plugin.getConfiguration().get(ConfigKeys.APPLYING_WILDCARDS).booleanValue()) {
            processors.add(new WildcardProcessor());
        }
        if (this.plugin.getConfiguration().get(ConfigKeys.APPLYING_WILDCARDS_SPONGE).booleanValue()) {
            processors.add(new SpongeWildcardProcessor());
        }
        if ((integratedOwner = queryOptions.option(FabricContextManager.INTEGRATED_SERVER_OWNER).orElse(false).booleanValue()) && this.plugin.getConfiguration().get(ConfigKeys.INTEGRATED_SERVER_OWNER_BYPASSES_CHECKS).booleanValue()) {
            processors.add(ServerOwnerProcessor.INSTANCE);
        }
        return new PermissionCalculator(this.plugin, metadata, processors);
    }
}

