/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.fabric;

import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import me.lucko.luckperms.common.api.LuckPermsApiProvider;
import me.lucko.luckperms.common.calculator.CalculatorFactory;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.config.generic.adapter.ConfigurationAdapter;
import me.lucko.luckperms.common.dependencies.Dependency;
import me.lucko.luckperms.common.event.AbstractEventBus;
import me.lucko.luckperms.common.locale.TranslationManager;
import me.lucko.luckperms.common.messaging.MessagingFactory;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.model.manager.group.StandardGroupManager;
import me.lucko.luckperms.common.model.manager.track.StandardTrackManager;
import me.lucko.luckperms.common.model.manager.user.StandardUserManager;
import me.lucko.luckperms.common.plugin.AbstractLuckPermsPlugin;
import me.lucko.luckperms.common.sender.DummyConsoleSender;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.fabric.FabricCalculatorFactory;
import me.lucko.luckperms.fabric.FabricCommandExecutor;
import me.lucko.luckperms.fabric.FabricConfigAdapter;
import me.lucko.luckperms.fabric.FabricEventBus;
import me.lucko.luckperms.fabric.FabricSenderFactory;
import me.lucko.luckperms.fabric.LPFabricBootstrap;
import me.lucko.luckperms.fabric.context.FabricContextManager;
import me.lucko.luckperms.fabric.context.FabricPlayerCalculator;
import me.lucko.luckperms.fabric.listeners.FabricAutoOpListener;
import me.lucko.luckperms.fabric.listeners.FabricCommandListUpdater;
import me.lucko.luckperms.fabric.listeners.FabricConnectionListener;
import me.lucko.luckperms.fabric.listeners.FabricOtherListeners;
import me.lucko.luckperms.fabric.listeners.FabricPermissionsApiListener;
import me.lucko.luckperms.fabric.messaging.FabricMessagingFactory;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.ModContainer;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.query.QueryOptions;
import net.minecraft.class_3326;
import net.minecraft.server.MinecraftServer;

public class LPFabricPlugin
extends AbstractLuckPermsPlugin {
    private final LPFabricBootstrap bootstrap;
    private FabricConnectionListener connectionListener;
    private FabricCommandExecutor commandManager;
    private FabricSenderFactory senderFactory;
    private FabricContextManager contextManager;
    private StandardUserManager userManager;
    private StandardGroupManager groupManager;
    private StandardTrackManager trackManager;

    public LPFabricPlugin(LPFabricBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    @Override
    public LPFabricBootstrap getBootstrap() {
        return this.bootstrap;
    }

    protected void registerFabricListeners() {
        this.connectionListener = new FabricConnectionListener(this);
        this.connectionListener.registerListeners();
        new FabricPermissionsApiListener(this).registerListeners();
        if (!this.skipCommandRegistration()) {
            this.commandManager = new FabricCommandExecutor(this);
            this.commandManager.register();
        }
        new FabricOtherListeners(this).registerListeners();
    }

    @Override
    protected void setupSenderFactory() {
        this.senderFactory = new FabricSenderFactory(this);
    }

    @Override
    protected Set<Dependency> getGlobalDependencies() {
        Set<Dependency> dependencies = super.getGlobalDependencies();
        dependencies.add(Dependency.CONFIGURATE_CORE);
        dependencies.add(Dependency.CONFIGURATE_HOCON);
        dependencies.add(Dependency.HOCON_CONFIG);
        return dependencies;
    }

    @Override
    protected ConfigurationAdapter provideConfigurationAdapter() {
        return new FabricConfigAdapter(this, this.resolveConfig("luckperms.conf"));
    }

    @Override
    protected void registerPlatformListeners() {
    }

    @Override
    protected MessagingFactory<?> provideMessagingFactory() {
        return new FabricMessagingFactory(this);
    }

    @Override
    protected void registerCommands() {
    }

    @Override
    protected void setupManagers() {
        this.userManager = new StandardUserManager(this);
        this.groupManager = new StandardGroupManager(this);
        this.trackManager = new StandardTrackManager(this);
    }

    @Override
    protected CalculatorFactory provideCalculatorFactory() {
        return new FabricCalculatorFactory(this);
    }

    @Override
    protected void setupContextManager() {
        this.contextManager = new FabricContextManager(this);
        FabricPlayerCalculator playerCalculator = new FabricPlayerCalculator(this, this.getConfiguration().get(ConfigKeys.DISABLED_CONTEXTS));
        playerCalculator.registerListeners();
        this.contextManager.registerCalculator(playerCalculator);
    }

    @Override
    protected void setupPlatformHooks() {
    }

    protected AbstractEventBus<ModContainer> provideEventBus(LuckPermsApiProvider provider) {
        return new FabricEventBus(this, provider);
    }

    @Override
    protected void registerApiOnPlatform(LuckPerms api) {
    }

    @Override
    protected void performFinalSetup() {
        if (!this.getConfiguration().get(ConfigKeys.OPS_ENABLED).booleanValue()) {
            ServerLifecycleEvents.SERVER_STARTED.register(server -> {
                class_3326 operatorList = server.method_3760().method_14603();
                operatorList.method_14632().clear();
                try {
                    operatorList.method_14629();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            });
        }
        if (this.getConfiguration().get(ConfigKeys.AUTO_OP).booleanValue()) {
            ((AbstractEventBus)this.getApiProvider().getEventBus()).subscribe(new FabricAutoOpListener(this));
        }
        if (this.getConfiguration().get(ConfigKeys.UPDATE_CLIENT_COMMAND_LIST).booleanValue()) {
            ((AbstractEventBus)this.getApiProvider().getEventBus()).subscribe(new FabricCommandListUpdater(this));
        }
    }

    public FabricSenderFactory getSenderFactory() {
        return this.senderFactory;
    }

    @Override
    public FabricConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    @Override
    public FabricCommandExecutor getCommandManager() {
        return this.commandManager;
    }

    public FabricContextManager getContextManager() {
        return this.contextManager;
    }

    public StandardUserManager getUserManager() {
        return this.userManager;
    }

    public StandardGroupManager getGroupManager() {
        return this.groupManager;
    }

    public StandardTrackManager getTrackManager() {
        return this.trackManager;
    }

    @Override
    public Optional<QueryOptions> getQueryOptionsForUser(User user) {
        return this.bootstrap.getPlayer(user.getUniqueId()).map(player -> this.contextManager.getQueryOptions(player));
    }

    @Override
    public Stream<Sender> getOnlineSenders() {
        return Stream.concat(Stream.of(this.getConsoleSender()), this.bootstrap.getServer().map(MinecraftServer::method_3760).map(s -> s.method_14571().stream().map(p -> this.senderFactory.wrap(p.method_64396()))).orElseGet(Stream::empty));
    }

    @Override
    public Sender getConsoleSender() {
        return this.bootstrap.getServer().map(s -> this.senderFactory.wrap(s.method_3739())).orElseGet(() -> new DummyConsoleSender(this){

            @Override
            public void sendMessage(Component message) {
                LPFabricPlugin.this.bootstrap.getPluginLogger().info(PlainTextComponentSerializer.plainText().serialize(TranslationManager.render(message)));
            }
        });
    }
}

