/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.fabric.listeners;

import java.util.Map;
import me.lucko.luckperms.common.api.implementation.ApiUser;
import me.lucko.luckperms.common.event.LuckPermsEventListener;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.fabric.LPFabricPlugin;
import net.luckperms.api.event.EventBus;
import net.luckperms.api.event.context.ContextUpdateEvent;
import net.luckperms.api.event.user.UserDataRecalculateEvent;
import net.luckperms.api.query.QueryOptions;
import net.minecraft.class_3222;

public class FabricAutoOpListener
implements LuckPermsEventListener {
    private static final String NODE = "luckperms.autoop";
    private final LPFabricPlugin plugin;

    public FabricAutoOpListener(LPFabricPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void bind(EventBus bus) {
        bus.subscribe(UserDataRecalculateEvent.class, this::onUserDataRecalculate);
        bus.subscribe(ContextUpdateEvent.class, this::onContextUpdate);
    }

    private void onUserDataRecalculate(UserDataRecalculateEvent e) {
        User user = ApiUser.cast(e.getUser());
        this.plugin.getBootstrap().getPlayer(user.getUniqueId()).ifPresent(p -> this.refreshAutoOp((class_3222)p, false));
    }

    private void onContextUpdate(ContextUpdateEvent e) {
        e.getSubject(class_3222.class).ifPresent(p -> this.refreshAutoOp((class_3222)p, true));
    }

    private void refreshAutoOp(class_3222 player, boolean callerIsSync) {
        boolean value;
        if (!callerIsSync && !this.plugin.getBootstrap().getServer().isPresent()) {
            return;
        }
        User user = (User)this.plugin.getUserManager().getIfLoaded(player.method_5667());
        if (user != null) {
            QueryOptions queryOptions = this.plugin.getContextManager().getQueryOptions(player);
            Map<String, Boolean> permData = user.getCachedData().getPermissionData(queryOptions).getPermissionMap();
            value = permData.getOrDefault(NODE, false);
        } else {
            value = false;
        }
        if (callerIsSync) {
            this.setOp(player, value);
        } else {
            this.plugin.getBootstrap().getScheduler().executeSync(() -> this.setOp(player, value));
        }
    }

    private void setOp(class_3222 player, boolean value) {
        this.plugin.getBootstrap().getServer().ifPresent(server -> {
            if (value) {
                server.method_3760().method_14582(player.method_72498());
            } else {
                server.method_3760().method_14604(player.method_72498());
            }
        });
    }
}

