/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.fabric.mixin;

import me.lucko.luckperms.common.cacheddata.type.MonitoredMetaCache;
import me.lucko.luckperms.common.cacheddata.type.PermissionCache;
import me.lucko.luckperms.common.context.manager.QueryOptionsSupplier;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import me.lucko.luckperms.fabric.context.FabricContextManager;
import me.lucko.luckperms.fabric.model.MixinUser;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.util.Tristate;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
implements MixinUser {
    @Unique
    private User luckperms$user;
    @Unique
    private QueryOptionsSupplier luckperms$queryOptions;

    @Override
    public User luckperms$getUser() {
        return this.luckperms$user;
    }

    @Override
    public QueryOptionsSupplier luckperms$getQueryOptionsCache(FabricContextManager contextManager) {
        if (this.luckperms$queryOptions == null) {
            this.luckperms$queryOptions = contextManager.createQueryOptionsSupplier((class_3222)this);
        }
        return this.luckperms$queryOptions;
    }

    @Override
    public void luckperms$initializePermissions(User user) {
        if (user == null) {
            return;
        }
        this.luckperms$user = user;
        if (this.luckperms$queryOptions == null) {
            this.luckperms$getQueryOptionsCache((FabricContextManager)user.getPlugin().getContextManager());
        }
    }

    @Override
    public Tristate luckperms$hasPermission(String permission) {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        if (this.luckperms$user == null || this.luckperms$queryOptions == null) {
            return Tristate.UNDEFINED;
        }
        return this.luckperms$hasPermission(permission, this.luckperms$queryOptions.getQueryOptions());
    }

    @Override
    public Tristate luckperms$hasPermission(String permission, QueryOptions queryOptions) {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        if (queryOptions == null) {
            throw new NullPointerException("queryOptions");
        }
        User user = this.luckperms$user;
        if (user == null || this.luckperms$queryOptions == null) {
            return Tristate.UNDEFINED;
        }
        PermissionCache data = user.getCachedData().getPermissionData(queryOptions);
        return data.checkPermission(permission, CheckOrigin.PLATFORM_API_HAS_PERMISSION).result();
    }

    @Override
    public String luckperms$getOption(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.luckperms$user == null || this.luckperms$queryOptions == null) {
            return null;
        }
        return this.luckperms$getOption(key, this.luckperms$queryOptions.getQueryOptions());
    }

    @Override
    public String luckperms$getOption(String key, QueryOptions queryOptions) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (queryOptions == null) {
            throw new NullPointerException("queryOptions");
        }
        User user = this.luckperms$user;
        if (user == null || this.luckperms$queryOptions == null) {
            return null;
        }
        MonitoredMetaCache cache = user.getCachedData().getMetaData(queryOptions);
        return cache.getMetaOrChatMetaValue(key, CheckOrigin.PLATFORM_API);
    }

    @Inject(at={@At(value="TAIL")}, method={"copyFrom"})
    private void luckperms$copyFrom(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        MixinUser oldMixin = (MixinUser)oldPlayer;
        this.luckperms$initializePermissions(oldMixin.luckperms$getUser());
    }
}

