/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.world.item.ItemStack;

public class ItemStackHelper {
    private ItemStackHelper() {
    }

    public static boolean areItemStackComponentsEqualIgnoreDurability(ItemStack stackA, ItemStack stackB) {
        if (stackA.isEmpty() && stackB.isEmpty()) {
            return true;
        }
        if (!stackA.isEmpty() && !stackB.isEmpty()) {
            if (stackA.getComponents().isEmpty() && !stackB.getComponents().isEmpty()) {
                return false;
            }
            return stackA.getComponents().isEmpty() || ItemStackHelper.areComponentsEqualIgnoreDurability(stackA.getComponents(), stackB.getComponents());
        }
        return false;
    }

    public static boolean areComponentsEqualIgnoreDurability(DataComponentMap componentsA, @Nullable DataComponentMap componentsB) {
        if (componentsA == componentsB) {
            return true;
        }
        if (componentsB == null || componentsA.size() != componentsB.size()) {
            return false;
        }
        for (TypedDataComponent typedDataComponent : componentsA) {
            if (!componentsB.has(typedDataComponent.type())) {
                return false;
            }
            if (typedDataComponent.type().equals((Object)DataComponents.DAMAGE) || Objects.equals(typedDataComponent.value(), componentsB.get(typedDataComponent.type()))) continue;
            return false;
        }
        return true;
    }
}

