import json

materials = [
    "leather",
    "chainmail",
    "iron",
    "golden",
    "diamond",
    "netherite",
]

pieces = [
    "helmet",
    "chestplate",
    "leggings",
    "boots",
]

trims = {
    "ender": 0.04,
    "zinc": 0.03,
    "brass": 0.02,
    "rose_quartz": 0.01,
}

files = 0

for material in materials:
    for piece in pieces:
        old = ""
        with open(f"C:/minecraft-assets/assets/minecraft/models/item/{material}_{piece}.json", "r") as f:
            old = json.load(f)
        
        for trim, value in trims.items():
            # Add override to old model
            old["overrides"].insert(0,
                {
                    "model": f"create_trimmed:item/{material}_{piece}_{trim}_trim",
                    "predicate": {
                        "trim_type": value
                    }
                })
            
            # Create model referenced in override
            with open(f"assets/create_trimmed/models/item/{material}_{piece}_{trim}_trim.json", "w") as f:
                json.dump({
                    "parent": "minecraft:item/generated",
                    "textures": {
                        "layer0": f"minecraft:item/{material}_{piece}",
                        "layer1": f"minecraft:trims/items/{piece}_trim_{trim}"
                    }
                }, f, indent=4)
                files += 1
                print(f"Created {material}_{piece}_{trim}_trim.json")

        # Write old model back
        with open(f"assets/minecraft/models/item/{material}_{piece}.json", "w") as f:
            json.dump(old, f, indent=4)
            files += 1
            print(f"Created {material}_{piece}.json")

print(f"Successfully created {files} files.")