/*
 * Decompiled with CFR 0.152.
 */
package net.dshbwlto.createbionics.entity.client.replete;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.dshbwlto.createbionics.entity.client.ModModelLayers;
import net.dshbwlto.createbionics.entity.client.replete.RepleteModel;
import net.dshbwlto.createbionics.entity.client.replete.RepleteVariant;
import net.dshbwlto.createbionics.entity.custom.RepleteEntity;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class RepleteRenderer
extends MobRenderer<RepleteEntity, RepleteModel<RepleteEntity>> {
    private static final Map<RepleteVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(RepleteVariant.class), map -> {
        map.put(RepleteVariant.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/replete/chocolate.png"));
        map.put(RepleteVariant.BRASS, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/replete/replete_brass.png"));
        map.put(RepleteVariant.NETHERITE1_COPPER, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/replete/replete_netherite1_copper.png"));
        map.put(RepleteVariant.NETHERITE1_BRASS, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/replete/replete_netherite1_brass.png"));
        map.put(RepleteVariant.NETHERITE2, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/replete/replete_netherite2.png"));
        map.put(RepleteVariant.NETHERITE3, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/replete/replete_netherite3.png"));
    });

    public RepleteRenderer(EntityRendererProvider.Context context) {
        super(context, new RepleteModel(context.bakeLayer(ModModelLayers.REPLETE)), 0.25f);
    }

    public ResourceLocation getTextureLocation(RepleteEntity entity) {
        return LOCATION_BY_VARIANT.get((Object)entity.getVariant());
    }

    public void render(RepleteEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int pPackedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.45f, 0.45f, 0.45f);
        }
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, pPackedLight);
    }
}

