/*
 * Decompiled with CFR 0.152.
 */
package net.dshbwlto.createbionics.fluid;

import java.util.function.Supplier;
import net.dshbwlto.createbionics.fluid.BaseFluidType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.joml.Vector3f;

public class BionicsFluidTypes {
    public static final ResourceLocation ANDESITE_STILL_RL = ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"block/fluid/molten_andesite_alloy_still");
    public static final ResourceLocation ANDESITE_FLOWING_RL = ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"block/fluid/molten_andesite_alloy_flow");
    public static final ResourceLocation LAVA_OVERLAY_RL = ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"block/wax_block");
    public static final ResourceLocation IRON_STILL_RL = ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"block/fluid/molten_industrial_iron_still");
    public static final ResourceLocation IRON_FLOWING_RL = ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"block/fluid/molten_industrial_iron_flow");
    public static final ResourceLocation BRASS_STILL_RL = ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"block/fluid/molten_brass_still");
    public static final ResourceLocation BRASS_FLOWING_RL = ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"block/fluid/molten_brass_flow");
    public static final ResourceLocation NETHERITE_STILL_RL = ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"block/fluid/molten_netherite_still");
    public static final ResourceLocation NETHERITE_FLOWING_RL = ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"block/fluid/molten_netherite_flow");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES, (String)"createbionics");
    public static final Supplier<FluidType> MOLTEN_ANDESITE_ALLOY_FLUID_TYPE = BionicsFluidTypes.registerFluidType("molten_andesite_alloy", new BaseFluidType(ANDESITE_STILL_RL, ANDESITE_FLOWING_RL, LAVA_OVERLAY_RL, -1, new Vector3f(0.42352942f, 0.65882355f, 0.83137256f), FluidType.Properties.create().viscosity(100).lightLevel(2).temperature(300)));
    public static final Supplier<FluidType> MOLTEN_INDUSTRIAL_IRON_FLUID_TYPE = BionicsFluidTypes.registerFluidType("molten_industrial_iron", new BaseFluidType(IRON_STILL_RL, IRON_FLOWING_RL, LAVA_OVERLAY_RL, -1, new Vector3f(0.42352942f, 0.65882355f, 0.83137256f), FluidType.Properties.create().viscosity(300).lightLevel(5).temperature(300)));
    public static final Supplier<FluidType> MOLTEN_BRASS_FLUID_TYPE = BionicsFluidTypes.registerFluidType("molten_brass", new BaseFluidType(BRASS_STILL_RL, BRASS_FLOWING_RL, LAVA_OVERLAY_RL, -1, new Vector3f(0.42352942f, 0.65882355f, 0.83137256f), FluidType.Properties.create().viscosity(400).lightLevel(10).temperature(300)));
    public static final Supplier<FluidType> MOLTEN_NETHERITE_FLUID_TYPE = BionicsFluidTypes.registerFluidType("molten_netherite", new BaseFluidType(NETHERITE_STILL_RL, NETHERITE_FLOWING_RL, LAVA_OVERLAY_RL, -1, new Vector3f(0.42352942f, 0.65882355f, 0.83137256f), FluidType.Properties.create().viscosity(500).lightLevel(15).temperature(300)));

    private static Supplier<FluidType> registerFluidType(String name, FluidType fluidType) {
        return FLUID_TYPES.register(name, () -> fluidType);
    }

    public static void register(IEventBus eventBus) {
        FLUID_TYPES.register(eventBus);
    }
}

