/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.attributefilter;

import com.hlysine.create_connected.CCItemAttributes;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ItemStackCountAttribute(int stackSize) implements ItemAttribute
{
    public static final MapCodec<ItemStackCountAttribute> CODEC = Codec.INT.xmap(ItemStackCountAttribute::new, ItemStackCountAttribute::stackSize).fieldOf("value");
    public static final StreamCodec<ByteBuf, ItemStackCountAttribute> STREAM_CODEC = ByteBufCodecs.INT.map(ItemStackCountAttribute::new, ItemStackCountAttribute::stackSize);

    public boolean appliesTo(ItemStack stack, Level world) {
        return stack.getMaxStackSize() == this.stackSize;
    }

    public ItemAttributeType getType() {
        return CCItemAttributes.STACK_SIZE;
    }

    public String getTranslationKey() {
        return "stack_size";
    }

    public Object[] getTranslationParameters() {
        return new Object[]{String.valueOf(this.stackSize)};
    }

    public static class Type
    implements ItemAttributeType {
        @NotNull
        public ItemAttribute createAttribute() {
            return new ItemStackCountAttribute(64);
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
            attributes.add(new ItemStackCountAttribute(stack.getMaxStackSize()));
            return attributes;
        }

        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, ? extends ItemAttribute> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

