/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.item.ItemPredicate;
import dev.latvian.mods.kubejs.script.data.VirtualDataMapFile;
import java.util.stream.Stream;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.registries.datamaps.builtin.Compostable;

public record CompostableRecipesKubeEvent(VirtualDataMapFile<Item, Compostable> compostables) implements KubeEvent
{
    public void add(ItemPredicate match, float f) {
        this.add(match, f, false);
    }

    public void add(ItemPredicate match, float f, boolean villager) {
        Compostable data = new Compostable(f, villager);
        CompostableRecipesKubeEvent.dissolve(match).ifLeft(tag -> this.compostables.addTag((TagKey<Item>)tag, data)).ifRight(items -> items.forEach(item -> this.compostables.add((Item)item, data)));
    }

    public void addReplace(ItemPredicate match, float f) {
        this.addReplace(match, f, false);
    }

    public void addReplace(ItemPredicate match, float f, boolean villager) {
        Compostable data = new Compostable(f, villager);
        CompostableRecipesKubeEvent.dissolve(match).ifLeft(tag -> this.compostables.addTag((TagKey<Item>)tag, data, true)).ifRight(items -> items.forEach(item -> this.compostables.add((Item)item, data, true)));
    }

    public void replaceAll() {
        this.compostables.replaceAll();
    }

    public void remove(ItemPredicate match) {
        CompostableRecipesKubeEvent.dissolve(match).ifLeft(this.compostables::removeTag).ifRight(items -> items.forEach(this.compostables::remove));
    }

    public void removeAll() {
        this.compostables.clear();
        this.replaceAll();
    }

    private static Either<TagKey<Item>, Stream<Item>> dissolve(ItemPredicate filter) {
        TagKey tag;
        if (filter instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)filter;
            v0 = ingredient.kjs$getTagKey();
        } else {
            v0 = tag = null;
        }
        if (tag != null) {
            return Either.left((Object)tag);
        }
        return Either.right(filter.kjs$getItemStream());
    }
}

