/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.special;

import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.KubeEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class SpecialRecipeSerializerManager
implements KubeEvent {
    public static final SpecialRecipeSerializerManager INSTANCE = new SpecialRecipeSerializerManager();
    private final Map<ResourceLocation, Boolean> data = new HashMap<ResourceLocation, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<ResourceLocation, Boolean> map = this.data;
        synchronized (map) {
            this.data.clear();
        }
    }

    @Override
    public void afterPosted(EventResult result) {
        NeoForge.EVENT_BUS.post((Event)new AfterPost());
    }

    public boolean isSpecial(Recipe<?> recipe) {
        return this.data.getOrDefault(BuiltInRegistries.RECIPE_SERIALIZER.getKey((Object)recipe.getSerializer()), recipe.isSpecial());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreSpecialFlag(ResourceLocation id) {
        Map<ResourceLocation, Boolean> map = this.data;
        synchronized (map) {
            this.data.put(id, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpecialFlag(ResourceLocation id) {
        Map<ResourceLocation, Boolean> map = this.data;
        synchronized (map) {
            this.data.put(id, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreSpecialMod(String modid) {
        Map<ResourceLocation, Boolean> map = this.data;
        synchronized (map) {
            for (Map.Entry entry : BuiltInRegistries.RECIPE_SERIALIZER.entrySet()) {
                if (!((ResourceKey)entry.getKey()).location().getNamespace().equals(modid)) continue;
                this.data.put(((ResourceKey)entry.getKey()).location(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpecialMod(String modid) {
        Map<ResourceLocation, Boolean> map = this.data;
        synchronized (map) {
            for (Map.Entry entry : BuiltInRegistries.RECIPE_SERIALIZER.entrySet()) {
                if (!((ResourceKey)entry.getKey()).location().getNamespace().equals(modid)) continue;
                this.data.put(((ResourceKey)entry.getKey()).location(), true);
            }
        }
    }

    public static final class AfterPost
    extends Event {
    }
}

