/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.overstressclutch;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.ConnectedLang;
import com.hlysine.create_connected.content.overstressclutch.OverstressClutchBlockEntity;
import com.hlysine.create_connected.datagen.advancements.AdvancementBehaviour;
import com.hlysine.create_connected.datagen.advancements.CCAdvancements;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.AbstractEncasedShaftBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class OverstressClutchBlock
extends AbstractEncasedShaftBlock
implements IWrenchable,
IBE<OverstressClutchBlockEntity> {
    public static final EnumProperty<ClutchState> STATE = EnumProperty.create((String)"state", ClutchState.class);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public OverstressClutchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(STATE, (Comparable)((Object)ClutchState.COUPLED))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STATE, POWERED});
        super.createBlockStateDefinition(builder);
    }

    public void neighborChanged(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Block pBlock, @NotNull BlockPos pFromPos, boolean pIsMoving) {
        boolean flag1;
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        boolean flag = (Boolean)pState.getValue((Property)POWERED);
        boolean bl = flag1 = pLevel.getBestNeighborSignal(pPos) > 0;
        if (flag != flag1) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.cycle((Property)POWERED));
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, OverstressClutchBlockEntity::onKineticUpdate);
        }
    }

    public Class<OverstressClutchBlockEntity> getBlockEntityClass() {
        return OverstressClutchBlockEntity.class;
    }

    public BlockEntityType<? extends OverstressClutchBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.OVERSTRESS_CLUTCH.get();
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), OverstressClutchBlockEntity::resetClutch);
        return InteractionResult.SUCCESS;
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos) {
        return pState.getValue(STATE) == ClutchState.UNCOUPLED ? 0 : 15;
    }

    public void tick(@NotNull BlockState pState, ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (!(be instanceof OverstressClutchBlockEntity)) {
            return;
        }
        OverstressClutchBlockEntity kte = (OverstressClutchBlockEntity)be;
        ClutchState state = (ClutchState)((Object)pState.getValue(STATE));
        if (((Boolean)pState.getValue((Property)POWERED)).booleanValue()) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue(STATE, (Comparable)((Object)ClutchState.COUPLED)));
            kte.delay = 0;
            return;
        }
        if (state == ClutchState.COUPLED || state == ClutchState.UNCOUPLED) {
            kte.delay = 0;
            return;
        }
        if (kte.delay <= 0 && !pLevel.isClientSide) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue(STATE, (Comparable)((Object)ClutchState.UNCOUPLED)));
            RotationPropagator.handleRemoved((Level)pLevel, (BlockPos)pPos, (KineticBlockEntity)kte);
            RotationPropagator.handleAdded((Level)pLevel, (BlockPos)pPos, (KineticBlockEntity)kte);
            AdvancementBehaviour.tryAward((BlockEntity)kte, CCAdvancements.OVERSTRESS_CLUTCH);
            return;
        }
        --kte.delay;
    }

    public static enum ClutchState implements StringRepresentable
    {
        COUPLED,
        UNCOUPLING,
        UNCOUPLED;


        @NotNull
        public String getSerializedName() {
            return ConnectedLang.asId((String)this.name());
        }
    }
}

