/*
 * Decompiled with CFR 0.152.
 */
package net.dshbwlto.createbionics.entity.client.anole;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.dshbwlto.createbionics.entity.client.ModModelLayers;
import net.dshbwlto.createbionics.entity.client.anole.AnoleModel;
import net.dshbwlto.createbionics.entity.client.anole.AnoleVariant;
import net.dshbwlto.createbionics.entity.custom.AnoleEntity;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class AnoleRenderer
extends MobRenderer<AnoleEntity, AnoleModel<AnoleEntity>> {
    private static final Map<AnoleVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(AnoleVariant.class), map -> {
        map.put(AnoleVariant.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/anole/anole.png"));
        map.put(AnoleVariant.BRASS, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/anole/anole_brass.png"));
        map.put(AnoleVariant.NETHERITE, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/anole/anole_netherite.png"));
        map.put(AnoleVariant.ANDESITE, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/anole/anole_andesite.png"));
        map.put(AnoleVariant.EXPOSED, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/anole/anole_exposed.png"));
        map.put(AnoleVariant.WEATHERED, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/anole/anole_weathered.png"));
        map.put(AnoleVariant.OXIDIZED, ResourceLocation.fromNamespaceAndPath((String)"createbionics", (String)"textures/entity/anole/anole_oxidized.png"));
    });

    public AnoleRenderer(EntityRendererProvider.Context context) {
        super(context, new AnoleModel(context.bakeLayer(ModModelLayers.ANOLE)), 0.25f);
    }

    public ResourceLocation getTextureLocation(AnoleEntity entity) {
        return LOCATION_BY_VARIANT.get((Object)entity.getVariant());
    }

    public void render(AnoleEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int pPackedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.45f, 0.45f, 0.45f);
        }
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, pPackedLight);
    }
}

