/*
 * Decompiled with CFR 0.152.
 */
package net.dshbwlto.createbionics.entity.custom;

import java.util.function.Predicate;
import net.dshbwlto.createbionics.Util.BionicsTags;
import net.dshbwlto.createbionics.entity.BionicsEntities;
import net.dshbwlto.createbionics.entity.client.anole.AnoleVariant;
import net.dshbwlto.createbionics.item.BionicsItems;
import net.dshbwlto.createbionics.sound.BionicsSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class AnoleEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(AnoleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int fuelTime = 501;
    public boolean climbing = false;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState sitDownAnimationState = new AnimationState();
    public final AnimationState sitPoseAnimationState = new AnimationState();
    public final AnimationState sitUpAnimationState = new AnimationState();
    public static final EntityDataAccessor<Long> LAST_POSE_CHANGE_TICK = SynchedEntityData.defineId(AnoleEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    private static final EntityDataAccessor<ItemStack> DYE_STACK = SynchedEntityData.defineId(AnoleEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Boolean> HAT1 = SynchedEntityData.defineId(AnoleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAT2 = SynchedEntityData.defineId(AnoleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAT3 = SynchedEntityData.defineId(AnoleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAT4 = SynchedEntityData.defineId(AnoleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAT5 = SynchedEntityData.defineId(AnoleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAT6 = SynchedEntityData.defineId(AnoleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAT7 = SynchedEntityData.defineId(AnoleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAT8 = SynchedEntityData.defineId(AnoleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAT9 = SynchedEntityData.defineId(AnoleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public AnoleEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BionicsItems.COMMAND_WHISTLE.get()}), true));
        this.goalSelector.addGoal(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f));
        if (this.isTame()) {
            this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        }
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected PathNavigation createNavigation(Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 5.0).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.SAFE_FALL_DISTANCE, 200.0).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 200.0);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.BARRIER);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)BionicsEntities.ANOLE.get().create((Level)level);
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ITEM_BREAK;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.ANVIL_PLACE;
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            for (int i = 0; i < 1; ++i) {
                if (this.isCurrentlyGlowing()) continue;
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
        if (!this.isSitting() && !this.isPassenger() && !this.level().isClientSide && this.isAlive() && --this.fuelTime == 0 && this.isTame()) {
            this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.setGlowingTag(true);
            if (!this.isSitting()) {
                this.toggleSitting();
            }
            this.getOwner().sendSystemMessage((Component)Component.literal((String)(this.getOwner().getName().getString() + ", \u00a7cyour Anole has run out of fuel!\u00a7r")));
        }
        if (this.fuelTime == 500 && this.isTame()) {
            this.setGlowingTag(true);
            this.getOwner().sendSystemMessage((Component)Component.literal((String)(this.getOwner().getName().getString() + ", your Anole is running low on fuel! Top it up with coal or charcoal!")));
        }
        if (this.fuelTime == 100 && this.isTame()) {
            this.setGlowingTag(true);
            this.getOwner().sendSystemMessage((Component)Component.literal((String)(this.getOwner().getName().getString() + ", your Anole is running very low on fuel! Top it up with coal or charcoal immediately!")));
        }
        super.aiStep();
    }

    public boolean fireImmune() {
        if (this.getVariant() == AnoleVariant.NETHERITE) {
            return true;
        }
        return super.fireImmune();
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isVisuallySitting()) {
            this.sitUpAnimationState.stop();
            if (this.isVisuallySittingDown()) {
                this.sitDownAnimationState.startIfStopped(this.tickCount);
                this.sitPoseAnimationState.stop();
            } else {
                this.sitDownAnimationState.stop();
                this.sitPoseAnimationState.startIfStopped(this.tickCount);
            }
        } else {
            this.sitDownAnimationState.stop();
            this.sitPoseAnimationState.stop();
            this.sitUpAnimationState.animateWhen(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.tickCount);
        }
    }

    public boolean isInPoseTransition() {
        long i = this.getPoseTime();
        return i < (long)(this.isSitting() ? 40 : 52);
    }

    public boolean isVisuallySitting() {
        return this.getPoseTime() < 0L != this.isSitting();
    }

    private boolean isVisuallySittingDown() {
        return this.isSitting() && this.getPoseTime() < 40L && this.getPoseTime() >= 0L;
    }

    public void resetLastPoseChangeTick(long lastPoseChangeTick) {
        this.entityData.set(LAST_POSE_CHANGE_TICK, (Object)lastPoseChangeTick);
    }

    public long getPoseTime() {
        return this.level().getGameTime() - Math.abs((Long)this.entityData.get(LAST_POSE_CHANGE_TICK));
    }

    private void resetLastPoseChangeTickToFullStand(long lastPoseChangedTick) {
        this.resetLastPoseChangeTick(Math.max(0L, lastPoseChangedTick - 52L - 1L));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.horizontalCollision) {
            this.setPose(Pose.SITTING);
            Vec3 initialVec = this.getDeltaMovement();
            Vec3 climbVec = new Vec3(initialVec.x, 0.2, initialVec.z);
            this.setDeltaMovement(climbVec);
            this.climbing = true;
        } else {
            this.climbing = false;
        }
        if (this.tickCount % 30 == 0 && !this.isCurrentlyGlowing() && !this.isSilent()) {
            this.level().playLocalSound(this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5, BionicsSounds.ENGINE.get(), this.getSoundSource(), 0.01f + this.random.nextFloat(), 1.2f, false);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        Item itemForNetherite = Items.NETHERITE_INGOT;
        Item itemForRedstone = Items.REDSTONE;
        Item itemForGold = Items.GOLD_INGOT;
        Item itemForDiamond = Items.DIAMOND;
        Item itemForFuel = Items.CHARCOAL;
        if (item == itemForNetherite && this.isTame() && this.getVariant() != AnoleVariant.NETHERITE && this.getVariant() != AnoleVariant.BRASS && this.getVariant() != AnoleVariant.ANDESITE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.setVariant(AnoleVariant.NETHERITE);
            this.makeSound(SoundEvents.SMITHING_TABLE_USE);
        }
        if (itemstack.is(BionicsTags.Items.BRASS_INGOT) && this.isTame() && this.getVariant() != AnoleVariant.NETHERITE && this.getVariant() != AnoleVariant.BRASS && this.getVariant() != AnoleVariant.ANDESITE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.setVariant(AnoleVariant.BRASS);
            this.makeSound(SoundEvents.SMITHING_TABLE_USE);
        }
        if (itemstack.is((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"create:andesite_alloy"))) && this.isTame() && this.getVariant() != AnoleVariant.NETHERITE && this.getVariant() != AnoleVariant.BRASS && this.getVariant() != AnoleVariant.ANDESITE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.setVariant(AnoleVariant.ANDESITE);
            this.makeSound(SoundEvents.SMITHING_TABLE_USE);
        }
        if (item == Items.WET_SPONGE && this.getVariant() == AnoleVariant.WEATHERED) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            this.setVariant(AnoleVariant.OXIDIZED);
            this.makeSound(SoundEvents.WET_SPONGE_STEP);
        }
        if (item == Items.WET_SPONGE && this.getVariant() == AnoleVariant.EXPOSED) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            this.setVariant(AnoleVariant.WEATHERED);
            this.makeSound(SoundEvents.WET_SPONGE_STEP);
        }
        if (item == Items.WET_SPONGE && this.getVariant() == AnoleVariant.DEFAULT) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            this.setVariant(AnoleVariant.EXPOSED);
            this.makeSound(SoundEvents.WET_SPONGE_STEP);
        }
        if (item == Items.SPONGE && (this.getVariant() == AnoleVariant.EXPOSED || this.getVariant() == AnoleVariant.WEATHERED || this.getVariant() == AnoleVariant.OXIDIZED)) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            this.setVariant(AnoleVariant.DEFAULT);
            this.makeSound(SoundEvents.WET_SPONGE_STEP);
        }
        if (itemstack.is(BionicsTags.Items.WRENCH) && this.isTame() && this.getVariant() == AnoleVariant.NETHERITE && !player.isShiftKeyDown()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            this.spawnAtLocation(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            this.setVariant(AnoleVariant.DEFAULT);
            this.makeSound(SoundEvents.GRINDSTONE_USE);
        }
        if (itemstack.is(Tags.Items.MUSIC_DISCS) && this.isTame() && !player.isShiftKeyDown()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            itemstack.shrink(1);
            this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.VITTICEPS_MUSIC_DISC.get()));
        }
        if (itemstack.is(BionicsTags.Items.WRENCH) && this.isTame() && this.getVariant() == AnoleVariant.BRASS && !player.isShiftKeyDown()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            this.spawnAtLocation(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"create:brass_ingot"))));
            this.setVariant(AnoleVariant.DEFAULT);
            this.makeSound(SoundEvents.GRINDSTONE_USE);
        }
        if (itemstack.is(BionicsTags.Items.WRENCH) && this.isTame() && this.getVariant() == AnoleVariant.ANDESITE && !player.isShiftKeyDown()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            this.spawnAtLocation(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"create:andesite_alloy"))));
            this.setVariant(AnoleVariant.DEFAULT);
            this.makeSound(SoundEvents.GRINDSTONE_USE);
        }
        if (itemstack.is(BionicsTags.Items.WRENCH) && this.isOwnedBy((LivingEntity)player) && player.isShiftKeyDown()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.ANOLE.get()));
            if (this.getVariant() == AnoleVariant.NETHERITE) {
                this.spawnAtLocation(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            }
            if (this.getVariant() == AnoleVariant.BRASS) {
                this.spawnAtLocation(new ItemStack((ItemLike)Items.GOLD_INGOT));
            }
            if (this.isSilent()) {
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.SILENT_PISTON.get()));
            }
            this.remove(Entity.RemovalReason.DISCARDED);
            this.makeSound(SoundEvents.ITEM_PICKUP);
        }
        if ((item == Items.COAL || item == Items.CHARCOAL) && this.isOwnedBy((LivingEntity)player)) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.fuelTime = 100000;
            this.makeSound(SoundEvents.FIRECHARGE_USE);
            this.setGlowingTag(false);
            this.toggleSitting();
            this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            return InteractionResult.SUCCESS;
        }
        if (item == Items.COAL_BLOCK && this.isOwnedBy((LivingEntity)player)) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.fuelTime = 900000;
            this.makeSound(SoundEvents.FIRECHARGE_USE);
            this.makeSound(SoundEvents.FURNACE_FIRE_CRACKLE);
            this.setGlowingTag(false);
            return InteractionResult.SUCCESS;
        }
        if (item == BionicsItems.SILENT_PISTON.get() && this.isOwnedBy((LivingEntity)player) && !this.isSilent()) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.setSilent(true);
            return InteractionResult.SUCCESS;
        }
        if (!this.isTame() && this.getMainHandItem().isEmpty()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            if (!EventHooks.onAnimalTame((Animal)this, (Player)player)) {
                super.tame(player);
                this.navigation.recomputePath();
                this.setTarget(null);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
                this.fuelTime = 510;
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && !this.isShiftKeyDown() && !this.isCurrentlyGlowing() && player.getMainHandItem().isEmpty() && !this.isPassenger()) {
            this.toggleSitting();
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public boolean isSitting() {
        return (Long)this.entityData.get(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public void toggleSitting() {
        if (this.isSitting()) {
            this.standUp();
        } else {
            this.sitDown();
        }
    }

    public void sitDown() {
        if (!this.isSitting()) {
            this.setPose(Pose.SITTING);
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.resetLastPoseChangeTick(-this.level().getGameTime());
        }
        this.setOrderedToSit(true);
        this.setInSittingPose(true);
    }

    public void standUp() {
        if (this.isSitting()) {
            this.setPose(Pose.STANDING);
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.resetLastPoseChangeTick(this.level().getGameTime());
        }
        this.setOrderedToSit(false);
        this.setInSittingPose(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LAST_POSE_CHANGE_TICK, (Object)0L);
        builder.define(VARIANT, (Object)0);
        builder.define(DYE_STACK, (Object)ItemStack.EMPTY);
        builder.define(HAT1, (Object)true);
        builder.define(HAT2, (Object)false);
        builder.define(HAT3, (Object)false);
        builder.define(HAT4, (Object)false);
        builder.define(HAT5, (Object)false);
        builder.define(HAT6, (Object)false);
        builder.define(HAT7, (Object)false);
        builder.define(HAT8, (Object)false);
        builder.define(HAT9, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putLong("LastPoseTick", ((Long)this.entityData.get(LAST_POSE_CHANGE_TICK)).longValue());
        compound.putInt("Variant", this.getTypeVariant());
        compound.putInt("RefuelTime", this.fuelTime);
        compound.putBoolean("Hat1", this.hat1());
        compound.putBoolean("Hat2", this.hat2());
        compound.putBoolean("Hat3", this.hat3());
        compound.putBoolean("Hat4", this.hat4());
        compound.putBoolean("Hat5", this.hat5());
        compound.putBoolean("Hat6", this.hat6());
        compound.putBoolean("Hat7", this.hat7());
        compound.putBoolean("Hat8", this.hat8());
        compound.putBoolean("Hat9", this.hat9());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        long i = compound.getLong("LastPoseTick");
        if (i < 0L) {
            this.setPose(Pose.SITTING);
        }
        this.resetLastPoseChangeTick(i);
        this.entityData.set(VARIANT, (Object)compound.getInt("Variant"));
        if (compound.contains("RefuelTime")) {
            this.fuelTime = compound.getInt("RefuelTime");
        }
        this.entityData.set(HAT1, (Object)compound.getBoolean("Hat1"));
        this.entityData.set(HAT2, (Object)compound.getBoolean("Hat2"));
        this.entityData.set(HAT3, (Object)compound.getBoolean("Hat3"));
        this.entityData.set(HAT4, (Object)compound.getBoolean("Hat4"));
        this.entityData.set(HAT5, (Object)compound.getBoolean("Hat5"));
        this.entityData.set(HAT6, (Object)compound.getBoolean("Hat6"));
        this.entityData.set(HAT7, (Object)compound.getBoolean("Hat7"));
        this.entityData.set(HAT8, (Object)compound.getBoolean("Hat8"));
        this.entityData.set(HAT9, (Object)compound.getBoolean("Hat9"));
    }

    private void setTypeVariant(int typeVariant) {
        this.entityData.set(VARIANT, (Object)typeVariant);
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public AnoleVariant getVariant() {
        return AnoleVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(AnoleVariant variant) {
        this.entityData.set(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public boolean hat1() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return "Distinguished Gentleman".equals(s) || "Bill".equals(s);
    }

    public boolean hat2() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return "Timmy".equals(s);
    }

    public boolean hat3() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return "Unicorn".equals(s);
    }

    public boolean hat4() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return "Legend".equals(s) || "Techno".equals(s) || "Alex".equals(s);
    }

    public boolean hat5() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return "Stampy".equals(s);
    }

    public boolean hat6() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return "Doug".equals(s) || "Dimmadome".equals(s) || "Mayor".equals(s);
    }

    public boolean hat7() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return "Cat in the Hat".equals(s);
    }

    public boolean hat8() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return "Sherlock".equals(s);
    }

    public boolean hat9() {
        String s = ChatFormatting.stripFormatting((String)this.getName().getString());
        return "Scallywag".equals(s);
    }
}

