/*
 * Decompiled with CFR 0.152.
 */
package com.NindyBun.watercanteens.data.recipies;

import com.NindyBun.watercanteens.items.FilledCanteen;
import com.NindyBun.watercanteens.registries.RegRecipes;
import dev.ghen.thirst.content.registry.ThirstComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;

public class CanteenSmeltingRecipe
extends SmeltingRecipe {
    public CanteenSmeltingRecipe(String group, CookingBookCategory category, Ingredient ingredient, ItemStack result, float exp, int time) {
        super(group, category, ingredient, result, exp, time);
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registries) {
        Item item;
        ItemStack stack = input.item();
        if (stack.get(ThirstComponent.PURITY) == null && (item = stack.getItem()) instanceof FilledCanteen) {
            FilledCanteen canteen = (FilledCanteen)item;
            stack.set(ThirstComponent.PURITY, (Object)canteen.getCanteenTier().getPurity());
        }
        int purity = Math.min((Integer)stack.get(ThirstComponent.PURITY) + 2, 3);
        ItemStack result = this.result.copy();
        result.set(ThirstComponent.PURITY, (Object)purity);
        result.set(DataComponents.DAMAGE, (Object)stack.getDamageValue());
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RegRecipes.CANTEEN_SMELTING_RECIPE.get();
    }
}

