/*
 * Decompiled with CFR 0.152.
 */
package com.NindyBun.watercanteens.data.recipies.CookingRecipe;

import com.NindyBun.watercanteens.data.recipies.CookingRecipe.CanteenCookingRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class CanteenCookingSerializer<T extends CanteenCookingRecipe>
implements RecipeSerializer<T> {
    private final CanteenCookingRecipe.Factory<T> FACTORY;
    private final MapCodec<T> CODEC;
    private final StreamCodec<RegistryFriendlyByteBuf, T> STREAM_CODEC;

    public CanteenCookingSerializer(CanteenCookingRecipe.Factory<T> factory, int cookingTime) {
        this.FACTORY = factory;
        this.CODEC = RecordCodecBuilder.mapCodec(p_340782_ -> p_340782_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p -> p.group), (App)CookingBookCategory.CODEC.fieldOf("category").orElse((Object)CookingBookCategory.MISC).forGetter(p -> p.category), (App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("input").forGetter(p -> p.input), (App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("result").forGetter(p -> p.result), (App)Codec.FLOAT.fieldOf("exp").forGetter(p -> Float.valueOf(p.exp)), (App)Codec.INT.fieldOf("time").forGetter(p -> p.time)).apply((Applicative)p_340782_, factory::create));
        this.STREAM_CODEC = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    public MapCodec<T> codec() {
        return this.CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.STREAM_CODEC;
    }

    private T fromNetwork(RegistryFriendlyByteBuf buffer) {
        String s = buffer.readUtf();
        CookingBookCategory cookingbookcategory = (CookingBookCategory)buffer.readEnum(CookingBookCategory.class);
        ItemStack ingredient = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        float f = buffer.readFloat();
        int i = buffer.readVarInt();
        return this.FACTORY.create(s, cookingbookcategory, ingredient, itemstack, f, i);
    }

    private void toNetwork(RegistryFriendlyByteBuf buffer, T recipe) {
        buffer.writeUtf(((CanteenCookingRecipe)recipe).group);
        buffer.writeEnum((Enum)((CanteenCookingRecipe)recipe).category());
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)((CanteenCookingRecipe)recipe).input);
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)((CanteenCookingRecipe)recipe).result);
        buffer.writeFloat(((CanteenCookingRecipe)recipe).exp);
        buffer.writeVarInt(((CanteenCookingRecipe)recipe).time);
    }

    public CanteenCookingRecipe create(String group, CookingBookCategory category, ItemStack ingredient, ItemStack result, float experience, int cookingTime) {
        return this.FACTORY.create(group, category, ingredient, result, experience, cookingTime);
    }
}

