/*
 * Decompiled with CFR 0.152.
 */
package com.NindyBun.watercanteens.items;

import com.NindyBun.watercanteens.helpers.Utilities;
import com.NindyBun.watercanteens.items.CanteenTiers;
import com.NindyBun.watercanteens.items.FilledCanteen;
import com.NindyBun.watercanteens.registries.RegItems;
import dev.ghen.thirst.foundation.util.MathHelper;
import java.awt.Color;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class EmptyCanteen
extends Item {
    private final CanteenTiers canteenTier;

    public EmptyCanteen(CanteenTiers canteenTier) {
        super(new Item.Properties().stacksTo(1));
        this.canteenTier = canteenTier;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult context = MathHelper.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        BlockPos blockPos = context.getBlockPos();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        BlockState blockState = level.getBlockState(blockPos);
        int needed = this.canteenTier.getMaxUses();
        int[] fill = Utilities.fillCanteen(stack, needed, level, blockPos, blockEntity, blockState);
        if (fill[2] == 1) {
            ItemStack filled = ItemStack.EMPTY;
            if (this.canteenTier.equals((Object)CanteenTiers.LEATHER)) {
                filled = ((FilledCanteen)RegItems.FILLED_CANTEENS.get(RegItems.MATERIAL[0]).get(RegItems.PURITY[fill[0]]).get()).getDefaultInstance();
            } else if (this.canteenTier.equals((Object)CanteenTiers.IRON)) {
                filled = ((FilledCanteen)RegItems.FILLED_CANTEENS.get(RegItems.MATERIAL[1]).get(RegItems.PURITY[fill[0]]).get()).getDefaultInstance();
            } else if (this.canteenTier.equals((Object)CanteenTiers.COPPER)) {
                filled = ((FilledCanteen)RegItems.FILLED_CANTEENS.get(RegItems.MATERIAL[2]).get(RegItems.PURITY[fill[0]]).get()).getDefaultInstance();
            } else if (this.canteenTier.equals((Object)CanteenTiers.GOLD)) {
                filled = ((FilledCanteen)RegItems.FILLED_CANTEENS.get(RegItems.MATERIAL[3]).get(RegItems.PURITY[fill[0]]).get()).getDefaultInstance();
            } else if (this.canteenTier.equals((Object)CanteenTiers.DIAMOND)) {
                filled = ((FilledCanteen)RegItems.FILLED_CANTEENS.get(RegItems.MATERIAL[4]).get(RegItems.PURITY[fill[0]]).get()).getDefaultInstance();
            } else if (this.canteenTier.equals((Object)CanteenTiers.NETHERITE)) {
                filled = ((FilledCanteen)RegItems.FILLED_CANTEENS.get(RegItems.MATERIAL[5]).get(RegItems.PURITY[fill[0]]).get()).getDefaultInstance();
            } else if (this.canteenTier.equals((Object)CanteenTiers.DRAGON)) {
                filled = ((FilledCanteen)RegItems.FILLED_CANTEENS.get(RegItems.MATERIAL[6]).get(RegItems.PURITY[Math.max(fill[0], this.canteenTier.getPurity())]).get()).getDefaultInstance();
            }
            filled.setDamageValue(fill[1]);
            player.setItemInHand(hand, filled);
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public boolean isFoil(ItemStack stack) {
        return this.canteenTier == CanteenTiers.DRAGON;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)("0 / " + this.canteenTier.getMaxUses())).withColor(Color.CYAN.darker().getRGB()));
        if (this.canteenTier.equals((Object)CanteenTiers.DRAGON)) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.watercanteens.dragon-canteen-purity").withColor(Color.GRAY.darker().getRGB()));
        }
    }
}

