/*
 * Decompiled with CFR 0.152.
 */
package com.NindyBun.watercanteens.items;

import com.NindyBun.watercanteens.helpers.Utilities;
import com.NindyBun.watercanteens.items.CanteenTiers;
import com.NindyBun.watercanteens.items.Drinkable;
import com.NindyBun.watercanteens.registries.RegItems;
import dev.ghen.thirst.content.purity.WaterPurity;
import dev.ghen.thirst.content.registry.ThirstComponent;
import dev.ghen.thirst.foundation.util.MathHelper;
import java.awt.Color;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class FilledCanteen
extends Item
implements Drinkable {
    private final CanteenTiers canteenTier;
    private Item emptyCanteen;

    public FilledCanteen(CanteenTiers canteenTier, int purity) {
        super(new Item.Properties().stacksTo(1).durability(canteenTier.getMaxUses()).component(ThirstComponent.PURITY, (Object)purity));
        this.canteenTier = canteenTier;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        Player player;
        Player player2 = player = livingEntity instanceof Player ? (Player)livingEntity : null;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
            serverPlayer.gameEvent((Holder)GameEvent.DRINK);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.getAbilities().instabuild) {
                stack.hurtAndBreak(1, (ServerLevel)level, (LivingEntity)player, item -> {});
            }
        }
        if ((player == null || !player.getAbilities().instabuild) && stack.isEmpty()) {
            return new ItemStack((ItemLike)this.emptyCanteen);
        }
        level.gameEvent((Entity)livingEntity, (Holder)GameEvent.ITEM_INTERACT_FINISH, livingEntity.getEyePosition());
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult context = MathHelper.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        BlockPos blockPos = context.getBlockPos();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        BlockState blockState = level.getBlockState(blockPos);
        ItemStack filled = stack;
        int needed = stack.getDamageValue();
        int[] fill = Utilities.fillCanteen(filled, needed, level, blockPos, blockEntity, blockState);
        if (fill[2] == 1) {
            if (WaterPurity.getPurity((ItemStack)filled) != fill[0]) {
                if (this.canteenTier.equals((Object)CanteenTiers.LEATHER)) {
                    filled = ((FilledCanteen)RegItems.FILLED_CANTEENS.get(RegItems.MATERIAL[0]).get(RegItems.PURITY[fill[0]]).get()).getDefaultInstance();
                } else if (this.canteenTier.equals((Object)CanteenTiers.IRON)) {
                    filled = ((FilledCanteen)RegItems.FILLED_CANTEENS.get(RegItems.MATERIAL[1]).get(RegItems.PURITY[fill[0]]).get()).getDefaultInstance();
                } else if (this.canteenTier.equals((Object)CanteenTiers.COPPER)) {
                    filled = ((FilledCanteen)RegItems.FILLED_CANTEENS.get(RegItems.MATERIAL[2]).get(RegItems.PURITY[fill[0]]).get()).getDefaultInstance();
                } else if (this.canteenTier.equals((Object)CanteenTiers.GOLD)) {
                    filled = ((FilledCanteen)RegItems.FILLED_CANTEENS.get(RegItems.MATERIAL[3]).get(RegItems.PURITY[fill[0]]).get()).getDefaultInstance();
                } else if (this.canteenTier.equals((Object)CanteenTiers.DIAMOND)) {
                    filled = ((FilledCanteen)RegItems.FILLED_CANTEENS.get(RegItems.MATERIAL[4]).get(RegItems.PURITY[fill[0]]).get()).getDefaultInstance();
                } else if (this.canteenTier.equals((Object)CanteenTiers.NETHERITE)) {
                    filled = ((FilledCanteen)RegItems.FILLED_CANTEENS.get(RegItems.MATERIAL[5]).get(RegItems.PURITY[fill[0]]).get()).getDefaultInstance();
                } else if (this.canteenTier.equals((Object)CanteenTiers.DRAGON)) {
                    filled = ((FilledCanteen)RegItems.FILLED_CANTEENS.get(RegItems.MATERIAL[6]).get(RegItems.PURITY[Math.max(fill[0], this.canteenTier.getPurity())]).get()).getDefaultInstance();
                }
            }
            filled.setDamageValue(fill[1]);
            level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)filled);
    }

    public boolean isFoil(ItemStack stack) {
        return this.canteenTier == CanteenTiers.DRAGON;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)(this.getRemainingUses(stack) + " / " + this.canteenTier.getMaxUses())).withColor(Color.CYAN.darker().getRGB()));
        if (this.canteenTier.equals((Object)CanteenTiers.DRAGON)) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.watercanteens.dragon-canteen-purity").withColor(Color.GRAY.darker().getRGB()));
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public FilledCanteen setEmptyCanteen(Item emptyCanteen) {
        this.emptyCanteen = emptyCanteen;
        return this;
    }

    public Item getEmptyCanteen() {
        return this.emptyCanteen;
    }

    public CanteenTiers getCanteenTier() {
        return this.canteenTier;
    }

    @Override
    public int getMaxUses() {
        return this.canteenTier.getMaxUses();
    }

    @Override
    public int getRemainingUses(ItemStack stack) {
        return this.getMaxUses() - stack.getDamageValue();
    }
}

