/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.copycat.slab;

import com.hlysine.create_connected.content.copycat.slab.CopycatSlabBlock;
import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;

public class CopycatSlabModel
extends CopycatModel {
    protected static final AABB CUBE_AABB = new AABB(BlockPos.ZERO);

    public CopycatSlabModel(BakedModel originalModel) {
        super(originalModel);
    }

    protected List<BakedQuad> getCroppedQuads(BlockState state, Direction side, RandomSource rand, BlockState material, ModelData wrappedData, RenderType renderType) {
        Direction facing = state.getOptionalValue(CopycatSlabBlock.SLAB_TYPE).isPresent() ? CopycatSlabBlock.getApparentDirection(state) : Direction.UP;
        BakedModel model = CopycatSlabModel.getModelOf((BlockState)material);
        List templateQuads = model.getQuads(material, side, rand, wrappedData, renderType);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        boolean isDouble = state.getOptionalValue(CopycatSlabBlock.SLAB_TYPE).orElse(SlabType.BOTTOM) == SlabType.DOUBLE;
        for (boolean front : Iterate.trueAndFalse) {
            CopycatSlabModel.assemblePiece(facing, templateQuads, quads, front, false, isDouble);
        }
        if (isDouble) {
            for (boolean front : Iterate.trueAndFalse) {
                CopycatSlabModel.assemblePiece(facing, templateQuads, quads, front, true, isDouble);
            }
        }
        return quads;
    }

    private static void assemblePiece(Direction facing, List<BakedQuad> templateQuads, List<BakedQuad> quads, boolean front, boolean topSlab, boolean isDouble) {
        int size = templateQuads.size();
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)facing.getNormal());
        Vec3 normalScaled12 = normal.scale(0.75);
        Vec3 normalScaledN8 = topSlab ? normal.scale((double)((float)(front ? 0 : -8) / 16.0f)) : normal.scale((double)((float)(front ? 8 : 0) / 16.0f));
        float contract = 12.0f;
        AABB bb = CUBE_AABB.contract(normal.x * (double)contract / 16.0, normal.y * (double)contract / 16.0, normal.z * (double)contract / 16.0);
        if (!front) {
            bb = bb.move(normalScaled12);
        }
        for (int i = 0; i < size; ++i) {
            BakedQuad quad = templateQuads.get(i);
            Direction direction = quad.getDirection();
            if (front && direction == facing || !front && direction == facing.getOpposite() || isDouble && topSlab && direction == facing || isDouble && !topSlab && direction == facing.getOpposite()) continue;
            quads.add(BakedQuadHelper.cloneWithCustomGeometry((BakedQuad)quad, (int[])BakedModelHelper.cropAndMove((int[])quad.getVertices(), (TextureAtlasSprite)quad.getSprite(), (AABB)bb, (Vec3)normalScaledN8)));
        }
    }
}

