/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.core.EntityKJS;
import dev.latvian.mods.kubejs.entity.EntityPotionEffectsJS;
import dev.latvian.mods.kubejs.entity.KubeRayTraceResult;
import dev.latvian.mods.kubejs.item.FoodEatenKubeEvent;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.item.ItemPredicate;
import dev.latvian.mods.kubejs.plugin.builtin.event.ItemEvents;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
public interface LivingEntityKJS
extends EntityKJS {
    public static final ResourceLocation KJS_PLAYER_CUSTOM_SPEED = KubeJS.id("player.speed.modifier");

    default public LivingEntity kjs$self() {
        return (LivingEntity)this;
    }

    default public void kjs$foodEaten(ItemStack is, FoodProperties food) {
        LivingEntityKJS livingEntityKJS = this;
        if (livingEntityKJS instanceof LivingEntity) {
            ResourceKey key;
            LivingEntity entity = (LivingEntity)livingEntityKJS;
            FoodEatenKubeEvent event = new FoodEatenKubeEvent(entity, is);
            Item i = is.getItem();
            ItemBuilder b = i.kjs$getItemBuilder();
            if (b != null && b.foodBuilder != null && b.foodBuilder.eaten != null) {
                b.foodBuilder.eaten.accept(event);
            }
            if (ItemEvents.FOOD_EATEN.hasListeners((ResourceKey<Item>)(key = i.kjs$getKey()))) {
                ItemEvents.FOOD_EATEN.post((ScriptTypeHolder)entity, (ResourceKey<Item>)key, event);
            }
        }
    }

    @Override
    default public boolean kjs$isLiving() {
        return true;
    }

    default public void kjs$setMaxHealth(float hp) {
        this.kjs$self().getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)hp);
    }

    default public boolean kjs$isUndead() {
        return this.kjs$self().isInvertedHealAndHarm();
    }

    default public EntityPotionEffectsJS kjs$getPotionEffects() {
        return new EntityPotionEffectsJS(this.kjs$self());
    }

    default public void kjs$swing(InteractionHand hand) {
        this.kjs$self().swing(hand, true);
    }

    default public void kjs$swing() {
        this.kjs$self().swing(InteractionHand.MAIN_HAND, true);
    }

    default public ItemStack kjs$getEquipment(EquipmentSlot slot) {
        return this.kjs$self().getItemBySlot(slot);
    }

    default public void kjs$setEquipment(EquipmentSlot slot, ItemStack item) {
        this.kjs$self().setItemSlot(slot, item);
    }

    default public ItemStack kjs$getHeldItem(InteractionHand hand) {
        return this.kjs$self().getItemInHand(hand);
    }

    default public void kjs$setHeldItem(InteractionHand hand, ItemStack item) {
        this.kjs$self().setItemInHand(hand, item);
    }

    default public ItemStack kjs$getMainHandItem() {
        return this.kjs$getEquipment(EquipmentSlot.MAINHAND);
    }

    default public void kjs$setMainHandItem(ItemStack item) {
        this.kjs$setEquipment(EquipmentSlot.MAINHAND, item);
    }

    default public ItemStack kjs$getOffHandItem() {
        return this.kjs$getEquipment(EquipmentSlot.OFFHAND);
    }

    default public void kjs$setOffHandItem(ItemStack item) {
        this.kjs$setEquipment(EquipmentSlot.OFFHAND, item);
    }

    default public ItemStack kjs$getHeadArmorItem() {
        return this.kjs$getEquipment(EquipmentSlot.HEAD);
    }

    default public void kjs$setHeadArmorItem(ItemStack item) {
        this.kjs$setEquipment(EquipmentSlot.HEAD, item);
    }

    default public ItemStack kjs$getChestArmorItem() {
        return this.kjs$getEquipment(EquipmentSlot.CHEST);
    }

    default public void kjs$setChestArmorItem(ItemStack item) {
        this.kjs$setEquipment(EquipmentSlot.CHEST, item);
    }

    default public ItemStack kjs$getLegsArmorItem() {
        return this.kjs$getEquipment(EquipmentSlot.LEGS);
    }

    default public void kjs$setLegsArmorItem(ItemStack item) {
        this.kjs$setEquipment(EquipmentSlot.LEGS, item);
    }

    default public ItemStack kjs$getFeetArmorItem() {
        return this.kjs$getEquipment(EquipmentSlot.FEET);
    }

    default public void kjs$setFeetArmorItem(ItemStack item) {
        this.kjs$setEquipment(EquipmentSlot.FEET, item);
    }

    default public void kjs$damageEquipment(EquipmentSlot slot, int amount, Consumer<ItemStack> onBroken) {
        ItemStack stack = this.kjs$self().getItemBySlot(slot);
        if (!stack.isEmpty()) {
            stack.hurtAndBreak(amount, (ServerLevel)this.kjs$self().level(), this.kjs$self(), item -> onBroken.accept(stack));
            if (stack.isEmpty()) {
                this.kjs$self().setItemSlot(slot, ItemStack.EMPTY);
            }
        }
    }

    default public void kjs$damageEquipment(EquipmentSlot slot, int amount) {
        this.kjs$damageEquipment(slot, amount, stack -> {});
    }

    default public void kjs$damageEquipment(EquipmentSlot slot) {
        this.kjs$damageEquipment(slot, 1);
    }

    default public void kjs$damageHeldItem(InteractionHand hand, int amount, Consumer<ItemStack> onBroken) {
        this.kjs$damageEquipment(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, amount, onBroken);
    }

    default public void kjs$damageHeldItem(InteractionHand hand, int amount) {
        this.kjs$damageHeldItem(hand, amount, stack -> {});
    }

    default public void kjs$damageHeldItem() {
        this.kjs$damageHeldItem(InteractionHand.MAIN_HAND, 1);
    }

    default public boolean kjs$isHoldingInAnyHand(ItemPredicate i) {
        return i.test(this.kjs$self().getItemInHand(InteractionHand.MAIN_HAND)) || i.test(this.kjs$self().getItemInHand(InteractionHand.OFF_HAND));
    }

    default public double kjs$getTotalMovementSpeed() {
        return this.kjs$self().getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    default public double kjs$getDefaultMovementSpeed() {
        return this.kjs$self().getAttributeBaseValue(Attributes.MOVEMENT_SPEED);
    }

    default public void kjs$setDefaultMovementSpeed(double speed) {
        this.kjs$self().getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(speed);
    }

    default public void kjs$setMovementSpeedAddition(double speed) {
        AttributeInstance instance = this.kjs$self().getAttribute(Attributes.MOVEMENT_SPEED);
        if (instance != null) {
            instance.removeModifier(KJS_PLAYER_CUSTOM_SPEED);
            instance.addTransientModifier(this.kjs$createSpeedModifier(speed, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    default public void kjs$setDefaultMovementSpeedMultiplier(double speed) {
        AttributeInstance instance = this.kjs$self().getAttribute(Attributes.MOVEMENT_SPEED);
        if (instance != null) {
            instance.removeModifier(KJS_PLAYER_CUSTOM_SPEED);
            instance.addTransientModifier(this.kjs$createSpeedModifier(speed, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
    }

    default public void kjs$setTotalMovementSpeedMultiplier(double speed) {
        AttributeInstance instance = this.kjs$self().getAttribute(Attributes.MOVEMENT_SPEED);
        if (instance != null) {
            instance.removeModifier(KJS_PLAYER_CUSTOM_SPEED);
            instance.addTransientModifier(this.kjs$createSpeedModifier(speed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
    }

    default public boolean kjs$canEntityBeSeen(LivingEntity entity) {
        return BehaviorUtils.canSee((LivingEntity)this.kjs$self(), (LivingEntity)entity);
    }

    default public double kjs$getReachDistance() {
        return this.kjs$self().getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue();
    }

    default public KubeRayTraceResult kjs$rayTrace() {
        return this.kjs$rayTrace(this.kjs$getReachDistance());
    }

    @Nullable
    default public Entity kjs$rayTraceEntity(Predicate<Entity> filter) {
        return this.kjs$rayTraceEntity(this.kjs$getReachDistance(), filter);
    }

    default public double kjs$getAttributeTotalValue(Holder<Attribute> attribute) {
        AttributeInstance instance = this.kjs$self().getAttribute(attribute);
        if (instance != null) {
            return instance.getValue();
        }
        return 0.0;
    }

    default public double kjs$getAttributeBaseValue(Holder<Attribute> attribute) {
        AttributeInstance instance = this.kjs$self().getAttribute(attribute);
        if (instance != null) {
            return instance.getBaseValue();
        }
        return 0.0;
    }

    default public void kjs$setAttributeBaseValue(Holder<Attribute> attribute, double value) {
        AttributeInstance instance = this.kjs$self().getAttribute(attribute);
        if (instance != null) {
            instance.setBaseValue(value);
        }
    }

    default public void kjs$modifyAttribute(Holder<Attribute> attribute, ResourceLocation id, double amount, AttributeModifier.Operation operation) {
        AttributeInstance instance = this.kjs$self().getAttribute(attribute);
        if (instance != null) {
            instance.removeModifier(id);
            instance.addTransientModifier(new AttributeModifier(id, amount, operation));
        }
    }

    default public void kjs$removeAttribute(Holder<Attribute> attribute, ResourceLocation id) {
        AttributeInstance instance = this.kjs$self().getAttribute(attribute);
        if (instance != null) {
            instance.removeModifier(id);
        }
    }

    private AttributeModifier kjs$createSpeedModifier(double speed, AttributeModifier.Operation operation) {
        return new AttributeModifier(KJS_PLAYER_CUSTOM_SPEED, speed, operation);
    }
}

