/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.custom;

import dev.latvian.mods.kubejs.item.custom.HandheldItemBuilder;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.neoforged.neoforge.common.Tags;

public class DiggerItemBuilder
extends HandheldItemBuilder {
    public final BiFunction<Tier, Item.Properties, DiggerItem> function;

    public DiggerItemBuilder(ResourceLocation i, float d, float s, BiFunction<Tier, Item.Properties, DiggerItem> f) {
        super(i, d, s);
        this.function = f;
    }

    @Override
    public Item createObject() {
        this.itemAttributeModifiers = DiggerItem.createAttributes((Tier)this.toolTier, (float)this.attackDamageBaseline, (float)this.speedBaseline);
        return (Item)this.function.apply(this.toolTier, this.createItemProperties());
    }

    public static class Hoe
    extends DiggerItemBuilder {
        public static final ResourceLocation[] HOE_TAGS = new ResourceLocation[]{ItemTags.HOES.location()};
        public static final ResourceLocation HOE_MODEL = ResourceLocation.withDefaultNamespace((String)"item/iron_hoe");

        public Hoe(ResourceLocation i) {
            super(i, 0.0f, -3.0f, HoeItem::new);
            this.parentModel = HOE_MODEL;
            this.tag(HOE_TAGS);
        }
    }

    public static class Axe
    extends DiggerItemBuilder {
        public static final ResourceLocation[] AXE_TAGS = new ResourceLocation[]{ItemTags.AXES.location()};
        public static final ResourceLocation AXE_MODEL = ResourceLocation.withDefaultNamespace((String)"item/iron_axe");

        public Axe(ResourceLocation i) {
            super(i, 6.0f, -3.1f, AxeItem::new);
            this.parentModel = AXE_MODEL;
            this.tag(AXE_TAGS);
        }
    }

    public static class Shovel
    extends DiggerItemBuilder {
        public static final ResourceLocation[] SHOVEL_TAGS = new ResourceLocation[]{ItemTags.SHOVELS.location()};
        public static final ResourceLocation SHOVEL_MODEL = ResourceLocation.withDefaultNamespace((String)"item/iron_shovel");

        public Shovel(ResourceLocation i) {
            super(i, 1.5f, -3.0f, ShovelItem::new);
            this.parentModel = SHOVEL_MODEL;
            this.tag(SHOVEL_TAGS);
        }
    }

    public static class Pickaxe
    extends DiggerItemBuilder {
        public static final ResourceLocation[] PICKAXE_TAGS = new ResourceLocation[]{ItemTags.PICKAXES.location(), ItemTags.CLUSTER_MAX_HARVESTABLES.location(), Tags.Items.MINING_TOOL_TOOLS.location()};
        public static final ResourceLocation PICKAXE_MODEL = ResourceLocation.withDefaultNamespace((String)"item/iron_pickaxe");

        public Pickaxe(ResourceLocation i) {
            super(i, 1.0f, -2.8f, PickaxeItem::new);
            this.parentModel = PICKAXE_MODEL;
            this.tag(PICKAXE_TAGS);
        }
    }
}

