/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.plugin.builtin.wrapper;

import dev.latvian.mods.kubejs.plugin.builtin.wrapper.RegistryWrapper;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record DataMapWrapper<T, A>(Registry<T> registry, DataMapType<T, A> type) implements Iterable<Data<T, A>>
{
    public static DataMapWrapper<?, ?> of(Context cx, ResourceLocation registry, ResourceLocation id) {
        RegistryWrapper<?> reg = RegistryAccessContainer.of(cx).wrapRegistry(registry);
        return DataMapWrapper.of(reg, id);
    }

    public static DataMapType<?, ?> typeOf(Context cx, ResourceLocation registry, ResourceLocation id) {
        RegistryWrapper<?> reg = RegistryAccessContainer.of(cx).wrapRegistry(registry);
        return DataMapWrapper.typeOf(reg, id);
    }

    public static <T> DataMapWrapper<T, ?> of(RegistryWrapper<T> registry, ResourceLocation id) {
        DataMapType<T, ?> type = DataMapWrapper.typeOf(registry, id);
        return new DataMapWrapper(registry.registry(), type);
    }

    public static <T> DataMapType<T, ?> typeOf(RegistryWrapper<T> registry, ResourceLocation id) {
        return RegistryManager.getDataMap((ResourceKey)registry.registry().key(), (ResourceLocation)id);
    }

    @Nullable
    public A get(T item) {
        return (A)this.registry.getData(this.type, (ResourceKey)this.registry.getResourceKey(item).orElseThrow());
    }

    public Stream<T> keys() {
        return this.byKey().keySet().stream().map(arg_0 -> this.registry.get(arg_0));
    }

    @Override
    @NotNull
    public Iterator<Data<T, A>> iterator() {
        return new Iterator<Data<T, A>>(){
            final Iterator<Map.Entry<ResourceKey<T>, A>> backing;
            {
                this.backing = DataMapWrapper.this.byKey().entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.backing.hasNext();
            }

            @Override
            public Data<T, A> next() {
                Map.Entry entry = this.backing.next();
                return new Data(DataMapWrapper.this.registry.get(entry.getKey()), entry.getValue());
            }
        };
    }

    @NotNull
    public Map<ResourceKey<T>, A> byKey() {
        return this.registry.getDataMap(this.type);
    }

    public record Data<T, A>(T element, A data) {
    }
}

