/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.util.VoxelOutliner;

public class BlockHighlightRenderHelper {
    public static final RenderType OUTLINE_QUADS = RenderType.create((String)"storage_outline_quads", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.NO_CULL).setTransparencyState(RenderStateShard.NO_TRANSPARENCY).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setOutputState(RenderStateShard.MAIN_TARGET).createCompositeState(true));

    public static void renderThickEdges(PoseStack poseStack, MultiBufferSource bufferSource, int color, List<VoxelOutliner.Edge> edges, BlockPos originPos) {
        BlockHighlightRenderHelper.renderThickEdges(poseStack, bufferSource, color, edges, originPos.getX(), originPos.getY(), originPos.getZ());
    }

    public static void renderThickEdges(PoseStack poseStack, MultiBufferSource bufferSource, int color, List<VoxelOutliner.Edge> edges, double originX, double originY, double originZ) {
        VertexConsumer vertexConsumer = bufferSource.getBuffer(OUTLINE_QUADS);
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        PoseStack.Pose pose = poseStack.last();
        edges.forEach(edge -> BlockHighlightRenderHelper.emitThickLineOrtho(vertexConsumer, pose, edge.a(), edge.b(), 0.03125f, red, green, blue, 255, originX, originY, originZ));
    }

    public static void emitThickLineOrtho(VertexConsumer vc, PoseStack.Pose pose, Vec3 a, Vec3 b, float thickness, int r, int g, int bl, int alpha, double originX, double originY, double originZ) {
        Vec3 w;
        Vec3 v;
        float rh = thickness * 0.5f;
        Vec3 d = b.subtract(a);
        Vec3 u = new Vec3(Math.signum(d.x), Math.signum(d.y), Math.signum(d.z));
        Vec3 aEx = a.subtract(u.scale((double)rh));
        Vec3 bEx = b.add(u.scale((double)rh));
        if (u.x != 0.0) {
            v = new Vec3(0.0, 1.0, 0.0);
            w = new Vec3(0.0, 0.0, 1.0);
        } else if (u.y != 0.0) {
            v = new Vec3(1.0, 0.0, 0.0);
            w = new Vec3(0.0, 0.0, 1.0);
        } else {
            v = new Vec3(1.0, 0.0, 0.0);
            w = new Vec3(0.0, 1.0, 0.0);
        }
        Vec3 vOff = v.scale((double)rh);
        Vec3 wOff = w.scale((double)rh);
        Vec3 aVpWm = aEx.add(vOff).subtract(wOff);
        Vec3 aVpWp = aEx.add(vOff).add(wOff);
        Vec3 aVmWp = aEx.subtract(vOff).add(wOff);
        Vec3 aVmWm = aEx.subtract(vOff).subtract(wOff);
        Vec3 bVpWm = bEx.add(vOff).subtract(wOff);
        Vec3 bVpWp = bEx.add(vOff).add(wOff);
        Vec3 bVmWp = bEx.subtract(vOff).add(wOff);
        Vec3 bVmWm = bEx.subtract(vOff).subtract(wOff);
        BlockHighlightRenderHelper.emitQuad(vc, pose, aVpWm, aVpWp, bVpWp, bVpWm, r, g, bl, alpha, originX, originY, originZ);
        BlockHighlightRenderHelper.emitQuad(vc, pose, aVmWp, aVmWm, bVmWm, bVmWp, r, g, bl, alpha, originX, originY, originZ);
        BlockHighlightRenderHelper.emitQuad(vc, pose, aVmWp, aVpWp, bVpWp, bVmWp, r, g, bl, alpha, originX, originY, originZ);
        BlockHighlightRenderHelper.emitQuad(vc, pose, aVpWm, aVmWm, bVmWm, bVpWm, r, g, bl, alpha, originX, originY, originZ);
    }

    private static void emitQuad(VertexConsumer vc, PoseStack.Pose pose, Vec3 p0, Vec3 p1, Vec3 p2, Vec3 p3, int r, int g, int b, int a, double originX, double originY, double originZ) {
        BlockHighlightRenderHelper.add(vc, pose, p0, r, g, b, a, originX, originY, originZ);
        BlockHighlightRenderHelper.add(vc, pose, p1, r, g, b, a, originX, originY, originZ);
        BlockHighlightRenderHelper.add(vc, pose, p2, r, g, b, a, originX, originY, originZ);
        BlockHighlightRenderHelper.add(vc, pose, p3, r, g, b, a, originX, originY, originZ);
    }

    private static void add(VertexConsumer vc, PoseStack.Pose pose, Vec3 p, int r, int g, int b, int a, double originX, double originY, double originZ) {
        vc.addVertex(pose, (float)(p.x - originX), (float)(p.y - originY), (float)(p.z - originZ)).setColor(r, g, b, a);
    }
}

