/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.pump;

import net.neoforged.neoforge.common.ModConfigSpec;

public class PumpUpgradeConfig {
    public final ModConfigSpec.IntValue maxInputOutput;
    public final ModConfigSpec.DoubleValue stackMultiplierRatio;
    public final ModConfigSpec.IntValue filterSlots;

    public PumpUpgradeConfig(ModConfigSpec.Builder builder) {
        builder.comment("Pump Upgrade Settings").push("pumpUpgrade");
        this.filterSlots = builder.comment("Number of fluid filter slots").defineInRange("filterSlots", 4, 1, 20);
        this.maxInputOutput = builder.comment("How much mB can be transfered in / out per operation. This is a base transfer rate that gets multiplied by number of rows in storage and stack multiplier.").defineInRange("maxInputOutput", 20, 1, 1000);
        this.stackMultiplierRatio = builder.comment("Ratio that gets applied (multiplies) to inventory stack multiplier before this is applied to max input/output value. Value lower than 1 makes stack multiplier affect the capacity less, higher makes it affect the capacity more. 0 turns off stack multiplier affecting input/output").defineInRange("stackMultiplierRatio", 1.0, 0.0, 5.0);
        builder.pop();
    }
}

