/*
 * Decompiled with CFR 0.152.
 */
package net.dshbwlto.createbionics.entity.custom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.dshbwlto.createbionics.Util.BionicsTags;
import net.dshbwlto.createbionics.entity.client.oxhauler.OxhaulerVariant;
import net.dshbwlto.createbionics.item.BionicsItems;
import net.dshbwlto.createbionics.sound.BionicsSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class OxhaulerEntity
extends AbstractHorse {
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Long> LAST_POSE_CHANGE_TICK = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    private static final EntityDataAccessor<Boolean> HAS_BACK = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_FRONT = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_NECK = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_FUELED = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FIRST_FUEL = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SILENCED = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DEAD = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> WHITE = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LIGHT_GRAY = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> GRAY = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BLACK = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BROWN = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> RED = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ORANGE = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> YELLOW = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LIME = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> GREEN = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> CYAN = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LIGHT_BLUE = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BLUE = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> MAGENTA = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> PURPLE = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> PINK = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HARVESTER = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> PLOUGH = SynchedEntityData.defineId(OxhaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int fuelTime = 1;
    public float lastHealth = 0.0f;
    public float currentHealth = 0.0f;
    private static final Set<BlockPos> HARVESTED_BLOCKS = new HashSet<BlockPos>();

    public boolean silenced() {
        return (Boolean)this.entityData.get(SILENCED);
    }

    public boolean dead() {
        return (Boolean)this.entityData.get(DEAD);
    }

    public boolean isSaddled() {
        return true;
    }

    public boolean isTamed() {
        return true;
    }

    public OxhaulerEntity(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
        this.createInventory();
    }

    protected void registerGoals() {
        if (this.isFueled()) {
            this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
            this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        }
    }

    public boolean fireImmune() {
        return this.getVariant() == OxhaulerVariant.NETHERITE2;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.isFueled()) {
            if (this.tickCount % 2 == 0) {
                if (this.tickCount % 4 == 0) {
                    return BionicsSounds.OXHAULER_BELLOW_1.get();
                }
                return BionicsSounds.OXHAULER_BELLOW_2.get();
            }
            if (this.tickCount % 3 == 0) {
                return BionicsSounds.OXHAULER_BELLOW_3.get();
            }
            return BionicsSounds.OXHAULER_RELEASE_1.get();
        }
        return null;
    }

    public int getAmbientSoundInterval() {
        return 400;
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.MOVEMENT_SPEED, 0.07).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.JUMP_STRENGTH, (double)0.55f).add(Attributes.KNOCKBACK_RESISTANCE, 10.0);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 60;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void aiStep() {
        Object object;
        if (this.level().isClientSide) {
            for (int i = 0; i < 1; ++i) {
                if (!this.isFueled() || this.getVariant() == OxhaulerVariant.NETHERITE2) continue;
                if (this.isVehicle()) {
                    Particle particle1 = Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.2f), this.getY() + 0.85 + (double)this.random.nextFloat(), this.getRandomZ(0.2f), 0.0, 0.1, 0.0);
                    Particle particle2 = Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.2f), this.getY() + 0.85 + (double)this.random.nextFloat(), this.getRandomZ(0.2f), 0.0, 0.075, 0.0);
                    Particle particle3 = Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.2f), this.getY() + 0.85 + (double)this.random.nextFloat(), this.getRandomZ(0.2f), 0.0, 0.05, 0.0);
                    Particle particle4 = Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.2f), this.getY() + 0.85 + (double)this.random.nextFloat(), this.getRandomZ(0.2f), 0.0, 0.05, 0.0);
                    Particle particle5 = Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.2f), this.getY() + 0.85 + (double)this.random.nextFloat(), this.getRandomZ(0.2f), 0.0, 0.05, 0.0);
                    Particle particle6 = Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.2f), this.getY() + 0.85 + (double)this.random.nextFloat(), this.getRandomZ(0.2f), 0.0, 0.05, 0.0);
                    Particle particle7 = Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.2f), this.getY() + 0.85 + (double)this.random.nextFloat(), this.getRandomZ(0.2f), 0.0, 0.05, 0.0);
                    if (particle1 != null) {
                        particle1.scale(1.0f + this.random.nextFloat());
                        particle1.setLifetime(2);
                        particle2.scale(1.0f + this.random.nextFloat());
                        particle2.setLifetime(2);
                        particle3.scale(1.0f + this.random.nextFloat());
                        particle3.setLifetime(2);
                        particle4.scale(1.0f + this.random.nextFloat());
                        particle4.setLifetime(2);
                        particle5.scale(1.0f + this.random.nextFloat());
                        particle5.setLifetime(2);
                        particle6.scale(1.0f + this.random.nextFloat());
                        particle6.setLifetime(2);
                        particle7.scale(1.0f + this.random.nextFloat());
                        particle7.setLifetime(2);
                    }
                } else {
                    this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.1f), this.getY() + 0.8 + (double)this.random.nextFloat(), this.getRandomZ(0.1f), 0.0, 0.0, 0.0);
                    this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.1f), this.getY() + 0.8 + (double)this.random.nextFloat(), this.getRandomZ(0.1f), 0.0, 0.0, 0.0);
                    this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.1f), this.getY() + 0.8 + (double)this.random.nextFloat(), this.getRandomZ(0.1f), 0.0, 0.0, 0.0);
                }
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
        if (this.isVehicle() && !this.isPassenger() && !this.level().isClientSide && this.isAlive() && --this.fuelTime == 0) {
            this.ejectPassengers();
            this.setGlowingTag(true);
            this.entityData.set(IS_FUELED, (Object)false);
        }
        if (this.isInWater()) {
            if (((Boolean)this.entityData.get(IS_FUELED)).booleanValue()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, this.getRandomX(0.1f), this.getY() + 0.8 + (double)this.random.nextFloat(), this.getRandomZ(0.1f), 0.0, 0.0, 0.0);
                this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, this.getRandomX(0.1f), this.getY() + 0.8 + (double)this.random.nextFloat(), this.getRandomZ(0.1f), 0.0, 0.0, 0.0);
                this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, this.getRandomX(0.1f), this.getY() + 0.8 + (double)this.random.nextFloat(), this.getRandomZ(0.1f), 0.0, 0.0, 0.0);
                this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, this.getRandomX(0.1f), this.getY() + 0.8 + (double)this.random.nextFloat(), this.getRandomZ(0.1f), 0.0, 0.0, 0.0);
                if (((Boolean)this.entityData.get(HARVESTER)).booleanValue()) {
                    this.spawnAtLocation(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"create:mechanical_harvester"))));
                    this.entityData.set(HARVESTER, (Object)false);
                }
                if (((Boolean)this.entityData.get(PLOUGH)).booleanValue()) {
                    this.spawnAtLocation(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"create:mechanical_plough"))));
                    this.entityData.set(PLOUGH, (Object)false);
                }
            }
            this.entityData.set(IS_FUELED, (Object)false);
            this.fuelTime = 0;
            this.ejectPassengers();
        }
        if (this.getHealth() == 0.0f && !((Boolean)this.entityData.get(DEAD)).booleanValue()) {
            this.entityData.set(DEAD, (Object)true);
            if (!this.hasBack()) {
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_MIDDLE.get()));
            }
            if (this.hasBack() && !this.hasFront()) {
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_MIDDLE.get()));
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_REAR.get()));
            }
            if (this.hasFront() && !this.hasNeck()) {
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_MIDDLE.get()));
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_REAR.get()));
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_FRONT.get()));
            }
            if (this.hasNeck()) {
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_MIDDLE.get()));
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_REAR.get()));
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_FRONT.get()));
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_HEAD.get()));
            }
            if (this.getVariant() == OxhaulerVariant.COPPER) {
                this.spawnAtLocation(new ItemStack((ItemLike)Items.COPPER_INGOT));
            }
            if (this.getVariant() == OxhaulerVariant.NETHERITE1) {
                this.spawnAtLocation(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            }
            if (this.getVariant() == OxhaulerVariant.NETHERITE2) {
                this.spawnAtLocation(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
                this.spawnAtLocation(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            }
            if (((Boolean)this.entityData.get(SILENCED)).booleanValue()) {
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.SILENT_PISTON.get()));
            }
        }
        if (this.isVehicle() && this.isPlough() && (object = this.getPassengers()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)object;
            if (HARVESTED_BLOCKS.contains(this.getOnPos())) {
                return;
            }
            for (BlockPos pos : OxhaulerEntity.getBlocksToBeDestroyed(2, this.getOnPos(), serverPlayer)) {
                if (!this.getBlockStateOn().is(Blocks.DIRT) || !this.getBlockStateOn().is(Blocks.GRASS_BLOCK) || !this.getBlockStateOn().is(Blocks.DIRT_PATH)) continue;
                HARVESTED_BLOCKS.add(pos);
                serverPlayer.gameMode.destroyBlock(pos);
                HARVESTED_BLOCKS.remove(pos);
            }
        }
        super.aiStep();
    }

    public long getPoseTime() {
        return this.level().getGameTime() - Math.abs((Long)this.entityData.get(LAST_POSE_CHANGE_TICK));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
            if (this.tickCount % 30 == 0 && this.isFueled() && !((Boolean)this.entityData.get(SILENCED)).booleanValue()) {
                this.level().playLocalSound(this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5, BionicsSounds.ENGINE.get(), this.getSoundSource(), 1.0f + this.random.nextFloat(), 0.1f + this.random.nextFloat(), false);
            }
        }
    }

    public static List<BlockPos> getBlocksToBeDestroyed(int range, BlockPos initialBlockPos, ServerPlayer serverPlayer) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                positions.add(new BlockPos(initialBlockPos.getX() + x, initialBlockPos.getY(), initialBlockPos.getZ() + y));
            }
        }
        return positions;
    }

    public boolean canUseSlot(EquipmentSlot slot) {
        return true;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        Item itemForNetherite = Items.NETHERITE_INGOT;
        Item itemForBrass = Items.GOLD_INGOT;
        Item itemForCopper = Items.COPPER_INGOT;
        if (itemstack.isEmpty() && this.isFueled() && !player.isShiftKeyDown()) {
            this.doPlayerRide(player);
        }
        if (itemstack.isEmpty() && player.isShiftKeyDown()) {
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (item == itemForNetherite && this.isFueled()) {
            if (this.getVariant() == OxhaulerVariant.NETHERITE1) {
                if (this.level().isClientSide()) {
                    return InteractionResult.CONSUME;
                }
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                this.setVariant(OxhaulerVariant.NETHERITE2);
                this.makeSound(SoundEvents.SMITHING_TABLE_USE);
            } else if (this.getVariant() == OxhaulerVariant.DEFAULT) {
                if (this.level().isClientSide()) {
                    return InteractionResult.CONSUME;
                }
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                this.setVariant(OxhaulerVariant.NETHERITE1);
                this.makeSound(SoundEvents.SMITHING_TABLE_USE);
            }
            return InteractionResult.SUCCESS;
        }
        if (item == itemForCopper && this.getVariant() == OxhaulerVariant.DEFAULT) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.setVariant(OxhaulerVariant.COPPER);
            this.makeSound(SoundEvents.SMITHING_TABLE_USE);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.is(BionicsTags.Items.BRASS_INGOT) && this.getHealth() < this.getMaxHealth() && this.isFueled()) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.heal(10.0f);
            this.makeSound(SoundEvents.SMITHING_TABLE_USE);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.is(BionicsTags.Items.WRENCH) && this.getVariant() == OxhaulerVariant.NETHERITE1 && !player.isShiftKeyDown() && !((Boolean)this.entityData.get(HARVESTER)).booleanValue() && !((Boolean)this.entityData.get(PLOUGH)).booleanValue()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            this.setVariant(OxhaulerVariant.DEFAULT);
            this.makeSound(SoundEvents.GRINDSTONE_USE);
            this.spawnAtLocation(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
        }
        if (itemstack.is(BionicsTags.Items.WRENCH) && this.getVariant() == OxhaulerVariant.NETHERITE2 && !player.isShiftKeyDown() && !((Boolean)this.entityData.get(HARVESTER)).booleanValue() && !((Boolean)this.entityData.get(PLOUGH)).booleanValue()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            this.setVariant(OxhaulerVariant.DEFAULT);
            this.makeSound(SoundEvents.GRINDSTONE_USE);
            this.spawnAtLocation(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            this.spawnAtLocation(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
        }
        if (itemstack.is(BionicsTags.Items.WRENCH) && this.getVariant() == OxhaulerVariant.COPPER && !player.isShiftKeyDown() && !((Boolean)this.entityData.get(HARVESTER)).booleanValue() && !((Boolean)this.entityData.get(PLOUGH)).booleanValue()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            this.setVariant(OxhaulerVariant.DEFAULT);
            this.makeSound(SoundEvents.GRINDSTONE_USE);
            this.spawnAtLocation(new ItemStack((ItemLike)Items.COPPER_INGOT));
        }
        if (itemstack.is(BionicsTags.Items.WRENCH) && player.isShiftKeyDown()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            this.setRemoved(Entity.RemovalReason.DISCARDED);
            this.makeSound(SoundEvents.COPPER_BREAK);
            if (!this.hasBack()) {
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_MIDDLE.get()));
            }
            if (this.hasBack() && !this.hasFront()) {
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_MIDDLE.get()));
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_REAR.get()));
            }
            if (this.hasFront() && !this.hasNeck()) {
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_MIDDLE.get()));
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_REAR.get()));
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_FRONT.get()));
            }
            if (this.hasNeck()) {
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_MIDDLE.get()));
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_REAR.get()));
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_FRONT.get()));
                this.spawnAtLocation(new ItemStack((ItemLike)BionicsItems.OXHAULER_HEAD.get()));
            }
        }
        if (itemstack.is(BionicsTags.Items.WRENCH) && ((Boolean)this.entityData.get(HARVESTER)).booleanValue() && !((Boolean)this.entityData.get(PLOUGH)).booleanValue()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            this.entityData.set(HARVESTER, (Object)false);
            this.makeSound(SoundEvents.COPPER_BREAK);
            this.spawnAtLocation(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"create:mechanical_harvester"))));
        }
        if (itemstack.is(BionicsTags.Items.WRENCH) && ((Boolean)this.entityData.get(PLOUGH)).booleanValue() && !((Boolean)this.entityData.get(HARVESTER)).booleanValue()) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            this.entityData.set(PLOUGH, (Object)false);
            this.makeSound(SoundEvents.COPPER_BREAK);
            this.spawnAtLocation(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"create:mechanical_plough"))));
        }
        if (item == BionicsItems.OXHAULER_REAR.get() && !this.hasBack()) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.entityData.set(HAS_BACK, (Object)true);
            this.makeSound(SoundEvents.SMITHING_TABLE_USE);
        }
        if (item == BionicsItems.OXHAULER_FRONT.get() && this.hasBack() && !this.hasFront()) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.entityData.set(HAS_FRONT, (Object)true);
            this.makeSound(SoundEvents.SMITHING_TABLE_USE);
        }
        if (item == BionicsItems.OXHAULER_HEAD.get() && this.hasBack() && this.hasFront() && !this.hasNeck()) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.entityData.set(HAS_NECK, (Object)true);
            this.makeSound(SoundEvents.SMITHING_TABLE_USE);
        }
        if (item == BionicsItems.SILENT_PISTON.get()) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!((Boolean)this.entityData.get(SILENCED)).booleanValue()) {
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                this.entityData.set(SILENCED, (Object)true);
            } else {
                if (!player.getAbilities().instabuild) {
                    itemstack.grow(1);
                }
                this.entityData.set(SILENCED, (Object)false);
            }
        }
        if ((item == Items.COAL || item == Items.CHARCOAL) && this.hasNeck() && !this.isInWater()) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.entityData.set(IS_FUELED, (Object)true);
            this.fuelTime = 100000;
            this.makeSound(SoundEvents.FIRECHARGE_USE);
            if (!((Boolean)this.entityData.get(FIRST_FUEL)).booleanValue()) {
                this.entityData.set(FIRST_FUEL, (Object)true);
            }
            this.setGlowingTag(false);
        }
        if (item == Items.WHITE_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)true);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.LIGHT_GRAY_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)true);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.GRAY_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)true);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.BLACK_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)true);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.BROWN_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)true);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.RED_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)true);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.ORANGE_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)true);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.YELLOW_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)true);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.LIME_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)true);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.GREEN_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)true);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.CYAN_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)true);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.LIGHT_BLUE_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)true);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.BLUE_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)true);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.MAGENTA_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)true);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.PURPLE_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)true);
            this.entityData.set(PINK, (Object)false);
        }
        if (item == Items.PINK_DYE) {
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(WHITE, (Object)false);
            this.entityData.set(LIGHT_GRAY, (Object)false);
            this.entityData.set(GRAY, (Object)false);
            this.entityData.set(BLACK, (Object)false);
            this.entityData.set(BROWN, (Object)false);
            this.entityData.set(RED, (Object)false);
            this.entityData.set(ORANGE, (Object)false);
            this.entityData.set(YELLOW, (Object)false);
            this.entityData.set(LIME, (Object)false);
            this.entityData.set(GREEN, (Object)false);
            this.entityData.set(CYAN, (Object)false);
            this.entityData.set(LIGHT_BLUE, (Object)false);
            this.entityData.set(BLUE, (Object)false);
            this.entityData.set(MAGENTA, (Object)false);
            this.entityData.set(PURPLE, (Object)false);
            this.entityData.set(PINK, (Object)true);
        }
        if (itemstack.is((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"create:mechanical_harvester"))) && !((Boolean)this.entityData.get(PLOUGH)).booleanValue() && this.isFueled()) {
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(HARVESTER, (Object)true);
        }
        if (itemstack.is((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"create:mechanical_plough"))) && !((Boolean)this.entityData.get(HARVESTER)).booleanValue() && this.isFueled()) {
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
            itemstack.shrink(1);
            this.entityData.set(PLOUGH, (Object)true);
        }
        return InteractionResult.SUCCESS;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LAST_POSE_CHANGE_TICK, (Object)0L);
        builder.define(VARIANT, (Object)0);
        builder.define(HAS_BACK, (Object)false);
        builder.define(HAS_FRONT, (Object)false);
        builder.define(HAS_NECK, (Object)false);
        builder.define(IS_FUELED, (Object)false);
        builder.define(FIRST_FUEL, (Object)false);
        builder.define(SILENCED, (Object)false);
        builder.define(DEAD, (Object)false);
        builder.define(WHITE, (Object)false);
        builder.define(LIGHT_GRAY, (Object)false);
        builder.define(GRAY, (Object)false);
        builder.define(BLACK, (Object)false);
        builder.define(BROWN, (Object)false);
        builder.define(RED, (Object)true);
        builder.define(ORANGE, (Object)false);
        builder.define(YELLOW, (Object)false);
        builder.define(LIME, (Object)false);
        builder.define(GREEN, (Object)false);
        builder.define(CYAN, (Object)false);
        builder.define(LIGHT_BLUE, (Object)false);
        builder.define(BLUE, (Object)false);
        builder.define(MAGENTA, (Object)false);
        builder.define(PURPLE, (Object)false);
        builder.define(PINK, (Object)false);
        builder.define(HARVESTER, (Object)false);
        builder.define(PLOUGH, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putLong("LastPoseTick", ((Long)this.entityData.get(LAST_POSE_CHANGE_TICK)).longValue());
        compound.putInt("Variant", this.getTypeVariant());
        compound.putBoolean("HasBack", this.hasBack());
        compound.putBoolean("HasFront", this.hasFront());
        compound.putBoolean("HasNeck", this.hasNeck());
        compound.putBoolean("IsFueled", this.isFueled());
        compound.putBoolean("FirstFuel", this.firstFuel());
        compound.putBoolean("Silenced", this.silenced());
        compound.putBoolean("Dead", this.dead());
        compound.putBoolean("WhiteFlag", this.whiteFlag());
        compound.putBoolean("LightGrayFlag", this.lightGrayFlag());
        compound.putBoolean("GrayFlag", this.grayFlag());
        compound.putBoolean("BlackFlag", this.blackFlag());
        compound.putBoolean("BrownFlag", this.brownFlag());
        compound.putBoolean("RedFlag", this.redFlag());
        compound.putBoolean("OrangeFlag", this.orangeFlag());
        compound.putBoolean("YellowFlag", this.yellowFlag());
        compound.putBoolean("LimeFlag", this.limeFlag());
        compound.putBoolean("GreenFlag", this.greenFlag());
        compound.putBoolean("CyanFlag", this.cyanFlag());
        compound.putBoolean("LightBlueFlag", this.lightBlueFlag());
        compound.putBoolean("BlueFlag", this.blueFlag());
        compound.putBoolean("MagentaFlag", this.magentaFlag());
        compound.putBoolean("PurpleFlag", this.purpleFlag());
        compound.putBoolean("MagentaFlag", this.magentaFlag());
        compound.putBoolean("PinkFlag", this.pinkFlag());
        compound.putBoolean("Harvester", this.isHarvester());
        compound.putBoolean("Plough", this.isPlough());
        compound.putInt("RefuelTime", this.fuelTime);
        compound.putFloat("LastHealth", this.lastHealth);
        compound.putFloat("CurrentHealth", this.currentHealth);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        long i = compound.getLong("LastPoseTick");
        if (i < 0L) {
            this.setPose(Pose.SITTING);
        }
        this.entityData.set(VARIANT, (Object)compound.getInt("Variant"));
        this.entityData.set(HAS_BACK, (Object)compound.getBoolean("HasBack"));
        this.entityData.set(HAS_FRONT, (Object)compound.getBoolean("HasFront"));
        this.entityData.set(HAS_NECK, (Object)compound.getBoolean("HasNeck"));
        this.entityData.set(IS_FUELED, (Object)compound.getBoolean("IsFueled"));
        this.entityData.set(FIRST_FUEL, (Object)compound.getBoolean("FirstFuel"));
        this.entityData.set(SILENCED, (Object)compound.getBoolean("Silenced"));
        this.entityData.set(WHITE, (Object)compound.getBoolean("WhiteFlag"));
        this.entityData.set(LIGHT_GRAY, (Object)compound.getBoolean("LightGrayFlag"));
        this.entityData.set(GRAY, (Object)compound.getBoolean("GrayFlag"));
        this.entityData.set(BLACK, (Object)compound.getBoolean("BlackFlag"));
        this.entityData.set(BROWN, (Object)compound.getBoolean("BrownFlag"));
        this.entityData.set(RED, (Object)compound.getBoolean("RedFlag"));
        this.entityData.set(ORANGE, (Object)compound.getBoolean("OrangeFlag"));
        this.entityData.set(YELLOW, (Object)compound.getBoolean("YellowFlag"));
        this.entityData.set(LIME, (Object)compound.getBoolean("LimeFlag"));
        this.entityData.set(GREEN, (Object)compound.getBoolean("GreenFlag"));
        this.entityData.set(CYAN, (Object)compound.getBoolean("CyanFlag"));
        this.entityData.set(LIGHT_BLUE, (Object)compound.getBoolean("LightBlueFlag"));
        this.entityData.set(BLUE, (Object)compound.getBoolean("BlueFlag"));
        this.entityData.set(MAGENTA, (Object)compound.getBoolean("MagentaFlag"));
        this.entityData.set(PURPLE, (Object)compound.getBoolean("PurpleFlag"));
        this.entityData.set(PINK, (Object)compound.getBoolean("PinkFlag"));
        this.entityData.set(HARVESTER, (Object)compound.getBoolean("Harvester"));
        this.entityData.set(PLOUGH, (Object)compound.getBoolean("Plough"));
        this.entityData.set(DEAD, (Object)compound.getBoolean("Dead"));
        if (compound.contains("RefuelTime")) {
            this.fuelTime = compound.getInt("RefuelTime");
        }
        if (compound.contains("LastHealth")) {
            this.lastHealth = compound.getFloat("LastHealth");
        }
        if (compound.contains("CurrentHealth")) {
            this.currentHealth = compound.getFloat("CurrentHealth");
        }
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return super.getPassengerAttachmentPoint(entity, dimensions, partialTick).add(new Vec3(0.0, 0.15 * (double)partialTick, -0.5 * (double)partialTick).yRot(-this.getYRot() * ((float)Math.PI / 180)));
    }

    private void setTypeVariant(int typeVariant) {
        this.entityData.set(VARIANT, (Object)typeVariant);
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public OxhaulerVariant getVariant() {
        return OxhaulerVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(OxhaulerVariant variant) {
        this.entityData.set(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public boolean hasBack() {
        return (Boolean)this.entityData.get(HAS_BACK);
    }

    public boolean hasFront() {
        return (Boolean)this.entityData.get(HAS_FRONT);
    }

    public boolean hasNeck() {
        return (Boolean)this.entityData.get(HAS_NECK);
    }

    public boolean isFueled() {
        return (Boolean)this.entityData.get(IS_FUELED);
    }

    public boolean firstFuel() {
        return (Boolean)this.entityData.get(FIRST_FUEL);
    }

    public boolean whiteFlag() {
        return (Boolean)this.entityData.get(WHITE);
    }

    public boolean lightGrayFlag() {
        return (Boolean)this.entityData.get(LIGHT_GRAY);
    }

    public boolean grayFlag() {
        return (Boolean)this.entityData.get(GRAY);
    }

    public boolean blackFlag() {
        return (Boolean)this.entityData.get(BLACK);
    }

    public boolean brownFlag() {
        return (Boolean)this.entityData.get(BROWN);
    }

    public boolean redFlag() {
        return (Boolean)this.entityData.get(RED);
    }

    public boolean orangeFlag() {
        return (Boolean)this.entityData.get(ORANGE);
    }

    public boolean yellowFlag() {
        return (Boolean)this.entityData.get(YELLOW);
    }

    public boolean limeFlag() {
        return (Boolean)this.entityData.get(LIME);
    }

    public boolean greenFlag() {
        return (Boolean)this.entityData.get(GREEN);
    }

    public boolean cyanFlag() {
        return (Boolean)this.entityData.get(CYAN);
    }

    public boolean lightBlueFlag() {
        return (Boolean)this.entityData.get(LIGHT_BLUE);
    }

    public boolean blueFlag() {
        return (Boolean)this.entityData.get(BLUE);
    }

    public boolean magentaFlag() {
        return (Boolean)this.entityData.get(MAGENTA);
    }

    public boolean purpleFlag() {
        return (Boolean)this.entityData.get(PURPLE);
    }

    public boolean pinkFlag() {
        return (Boolean)this.entityData.get(PINK);
    }

    public boolean isHarvester() {
        return (Boolean)this.entityData.get(HARVESTER);
    }

    public boolean isPlough() {
        return (Boolean)this.entityData.get(PLOUGH);
    }
}

