/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua;

import com.google.common.primitives.Primitives;
import com.mojang.brigadier.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_3542;
import net.sandius.rembulan.ByteString;
import net.sandius.rembulan.ConversionException;
import net.sandius.rembulan.Conversions;
import net.sandius.rembulan.LuaMathOperators;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.impl.DefaultTable;
import net.wizardsoflua.extension.spell.api.resource.LuaConverters;
import net.wizardsoflua.extension.spell.spi.JavaToLuaConverter;
import net.wizardsoflua.extension.spell.spi.LuaConverter;
import net.wizardsoflua.extension.spell.spi.LuaToJavaConverter;
import net.wizardsoflua.lua.BadArgumentException;
import net.wizardsoflua.lua.EnumConverter;
import net.wizardsoflua.lua.module.types.Types;
import net.wizardsoflua.lua.table.TableIterable;
import org.jetbrains.annotations.Nullable;

public class Converters
implements LuaConverters {
    private final Set<Class<?>> supportedJavaClasses = new HashSet();
    private final Supplier<Types> typesSupplier;
    private final EnumConverter enumConverter = new EnumConverter();
    private final Map<Class<?>, LuaToJavaConverter<?, ?>> luaToJavaConverters = new HashMap();
    private final Map<Class<?>, JavaToLuaConverter<?>> javaToLuaConverters = new HashMap();

    public boolean isSupported(Class<?> javaClass) {
        return this.supportedJavaClasses.contains(javaClass);
    }

    public Converters(Supplier<Types> typesSupplier) {
        this.typesSupplier = Objects.requireNonNull(typesSupplier, "typesSupplier == null!");
    }

    public Types getTypes() {
        return this.typesSupplier.get();
    }

    @Override
    @Nullable
    public final <J> List<J> toJavaListNullable(Class<J> type, @Nullable Object luaObject, int argumentIndex, String argumentName, String functionOrPropertyName) throws BadArgumentException {
        return this.enrichBadArgException(argumentIndex, argumentName, functionOrPropertyName, () -> this.toJavaListNullable(type, luaObject));
    }

    @Override
    public final <J> List<J> toJavaList(Class<J> type, Object luaObject, int argumentIndex, String argumentName, String functionOrPropertyName) throws BadArgumentException {
        return this.enrichBadArgException(argumentIndex, argumentName, functionOrPropertyName, () -> this.toJavaList(type, luaObject));
    }

    @Override
    public final <J> Optional<J> toJavaOptional(Class<J> type, @Nullable Object luaObject, int argumentIndex, String argumentName, String functionOrPropertyName) throws BadArgumentException {
        return this.enrichBadArgException(argumentIndex, argumentName, functionOrPropertyName, () -> this.toJavaOptional(type, luaObject));
    }

    @Override
    @Nullable
    public final <J> J toJavaNullable(Class<J> type, @Nullable Object luaObject, int argumentIndex, String argumentName, String functionOrPropertyName) throws BadArgumentException {
        return (J)this.enrichBadArgException(argumentIndex, argumentName, functionOrPropertyName, () -> this.toJavaNullable(type, luaObject));
    }

    @Override
    public final <J> J toJava(Class<J> type, Object luaObject, int argumentIndex, String argumentName, String functionOrPropertyName) throws BadArgumentException {
        return (J)this.enrichBadArgException(argumentIndex, argumentName, functionOrPropertyName, () -> this.toJava(type, luaObject));
    }

    private <T> T enrichBadArgException(int argumentIndex, String argumentName, String functionOrPropertyName, Supplier<T> supplier) throws BadArgumentException {
        Objects.requireNonNull(argumentName, "argumentName == null!");
        try {
            return this.enrichBadArgException(argumentIndex, functionOrPropertyName, supplier);
        }
        catch (BadArgumentException ex) {
            ex.setArgumentName(argumentName);
            throw ex;
        }
    }

    private <J> J toJava(Class<J> type, Object luaObject, int argumentIndex, String functionOrPropertyName) throws BadArgumentException {
        return (J)this.enrichBadArgException(argumentIndex, functionOrPropertyName, () -> this.toJava(type, luaObject));
    }

    private <T> T enrichBadArgException(int argumentIndex, String functionOrPropertyName, Supplier<T> supplier) throws BadArgumentException {
        try {
            return this.enrichBadArgException(functionOrPropertyName, supplier);
        }
        catch (BadArgumentException ex) {
            ex.setArgumentIndex(argumentIndex);
            throw ex;
        }
    }

    @Override
    public <J> J castTo(Class<J> type, Object luaObject, int argumentIndex, String argumentName, String functionOrPropertyName) throws BadArgumentException {
        return (J)this.enrichBadArgException(argumentIndex, argumentName, functionOrPropertyName, () -> {
            if (!type.isInstance(luaObject)) {
                throw this.badArgument(type, luaObject);
            }
            return type.cast(luaObject);
        });
    }

    @Override
    public <J> Optional<J> castToOptional(Class<J> type, Object luaObject, int argumentIndex, String argumentName, String functionOrPropertyName) throws BadArgumentException {
        return this.enrichBadArgException(argumentIndex, argumentName, functionOrPropertyName, () -> {
            if (luaObject != null && !type.isInstance(luaObject)) {
                throw this.badArgument(type, luaObject);
            }
            return Optional.ofNullable(type.cast(luaObject));
        });
    }

    @Override
    public final <J> List<J> toJavaList(Class<J> type, Object[] args, String functionOrPropertyName) throws BadArgumentException {
        ArrayList<J> result = new ArrayList<J>(args.length);
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            int argumentIndex = i + 1;
            J javaObject = this.toJava(type, arg, argumentIndex, functionOrPropertyName);
            result.add(javaObject);
        }
        return result;
    }

    @Override
    @Nullable
    public final <J> List<J> toJavaListNullable(Class<J> type, @Nullable Object luaObject, String functionOrPropertyName) throws BadArgumentException {
        return this.enrichBadArgException(functionOrPropertyName, () -> this.toJavaListNullable(type, luaObject));
    }

    @Override
    public final <J> List<J> toJavaList(Class<J> type, Object luaObject, String functionOrPropertyName) throws BadArgumentException {
        return this.enrichBadArgException(functionOrPropertyName, () -> this.toJavaList(type, luaObject));
    }

    @Override
    public final <J> Optional<J> toJavaOptional(Class<J> type, @Nullable Object luaObject, String functionOrPropertyName) throws BadArgumentException {
        return this.enrichBadArgException(functionOrPropertyName, () -> this.toJavaOptional(type, luaObject));
    }

    @Override
    @Nullable
    public final <J> J toJavaNullable(Class<J> type, @Nullable Object luaObject, String functionOrPropertyName) throws BadArgumentException {
        return (J)this.enrichBadArgException(functionOrPropertyName, () -> this.toJavaNullable(type, luaObject));
    }

    @Override
    public final <J> J toJava(Class<J> type, Object luaObject, String functionOrPropertyName) throws BadArgumentException {
        return (J)this.enrichBadArgException(functionOrPropertyName, () -> this.toJava(type, luaObject));
    }

    private <T> T enrichBadArgException(String functionOrPropertyName, Supplier<T> supplier) throws BadArgumentException {
        Objects.requireNonNull(functionOrPropertyName, "functionOrPropertyName == null!");
        try {
            return supplier.get();
        }
        catch (BadArgumentException ex) {
            ex.setFunctionOrPropertyName(functionOrPropertyName);
            throw ex;
        }
    }

    @Nullable
    private <J> List<J> toJavaListNullable(Class<J> type, @Nullable Object luaObject) {
        if (luaObject == null) {
            return null;
        }
        return this.toJavaList(type, luaObject);
    }

    private <J> List<J> toJavaList(Class<J> type, Object luaObject) throws BadArgumentException {
        Table table = this.toJava(Table.class, luaObject);
        ArrayList<J> result = new ArrayList<J>();
        for (Map.Entry<Object, Object> entry : new TableIterable(table)) {
            J javaValue;
            Object luaValue = entry.getValue();
            try {
                javaValue = this.toJava(type, luaValue);
            }
            catch (BadArgumentException ex) {
                ByteString key = Conversions.toHumanReadableString((Object)entry.getKey());
                ex.setDetailMessage("table contained illegal value for key '" + String.valueOf(key) + "' (" + ex.getDetailMessage() + ")");
                throw ex;
            }
            result.add(javaValue);
        }
        return result;
    }

    private <J> Optional<J> toJavaOptional(Class<J> type, @Nullable Object luaObject) {
        return Optional.ofNullable(this.toJavaNullable(type, luaObject));
    }

    @Nullable
    private <J> J toJavaNullable(Class<J> type, @Nullable Object luaObject) {
        if (luaObject == null) {
            return null;
        }
        return this.toJava(type, luaObject);
    }

    private <J> J toJava(Class<J> type, Object luaObject) throws BadArgumentException {
        type = Primitives.wrap(type);
        if (luaObject == null) {
            throw this.badArgument(type, luaObject);
        }
        try {
            Object result = this.convertTo(type, luaObject);
            return (J)type.cast(result);
        }
        catch (ClassCastException ex) {
            BadArgumentException e = this.badArgument(type, luaObject);
            e.initCause(ex);
            throw e;
        }
    }

    private BadArgumentException badArgument(Class<?> expectedType, Object actualObject) {
        Types types = this.getTypes();
        String expected = types.getLuaTypeNameForJavaClass(expectedType);
        String actual = types.getLuaTypeNameOfLuaObject(actualObject);
        return new BadArgumentException(expected, actual);
    }

    @Override
    public void registerLuaConverter(LuaConverter<?, ?> converter) throws IllegalArgumentException {
        this.registerLuaToJavaConverter(converter);
        this.registerJavaToLuaConverter(converter);
    }

    @Override
    public void registerLuaToJavaConverter(LuaToJavaConverter<?, ?> converter) throws IllegalArgumentException {
        Class<?> javaClass = converter.getJavaClass();
        if (this.luaToJavaConverters.containsKey(javaClass)) {
            throw new IllegalArgumentException("A LuaToJavaConverter for java " + String.valueOf(javaClass) + " is already registered");
        }
        this.luaToJavaConverters.put(javaClass, converter);
    }

    @Override
    public void registerJavaToLuaConverter(JavaToLuaConverter<?> converter) throws IllegalArgumentException {
        Class<?> javaClass = converter.getJavaClass();
        this.supportedJavaClasses.add(javaClass);
        if (this.javaToLuaConverters.containsKey(javaClass)) {
            throw new IllegalArgumentException("A JavaToLuaConverter for java " + String.valueOf(javaClass) + " is already registered");
        }
        this.javaToLuaConverters.put(javaClass, converter);
    }

    public <J> LuaToJavaConverter<? super J, ?> getLuaToJavaConverter(Class<J> javaClass) {
        for (Class<J> cls = javaClass; cls != null; cls = cls.getSuperclass()) {
            LuaToJavaConverter<?, ?> result = this.luaToJavaConverters.get(cls);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public <J> JavaToLuaConverter<? super J> getJavaToLuaConverter(Class<J> javaClass) {
        for (Class<J> cls = javaClass; cls != null; cls = cls.getSuperclass()) {
            JavaToLuaConverter<?> result = this.javaToLuaConverters.get(cls);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private <L> Object convertToJava(Object luaObject, LuaToJavaConverter<?, L> converter) throws ClassCastException {
        Class<L> luaClass = converter.getLuaClass();
        L luaInstance = luaClass.cast(luaObject);
        return converter.getJavaInstance(luaInstance);
    }

    private Object convertTo(Class<?> javaClass, Object luaObject) throws ClassCastException, BadArgumentException {
        LuaToJavaConverter<?, ?> converter = this.getLuaToJavaConverter(javaClass);
        if (converter != null) {
            return this.convertToJava(luaObject, converter);
        }
        if (javaClass == String.class) {
            return Conversions.javaRepresentationOf((Object)luaObject);
        }
        if (javaClass == Double.class) {
            return this.castToDouble(luaObject);
        }
        if (javaClass == Float.class) {
            return this.castToFloat(luaObject);
        }
        if (javaClass == Integer.class) {
            return this.castToInt(luaObject);
        }
        if (javaClass == Long.class) {
            return this.castToLong(luaObject);
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return luaObject;
        }
        if (Enum.class.isAssignableFrom(javaClass)) {
            String name = (String)Conversions.javaRepresentationOf((Object)luaObject);
            return this.enumConverter.toJava(javaClass, name);
        }
        return luaObject;
    }

    private Double castToDouble(Object luaObject) throws ClassCastException, BadArgumentException {
        if (luaObject instanceof Long) {
            Long l = (Long)luaObject;
            if (LuaMathOperators.hasExactFloatRepresentation((long)l)) {
                return l.doubleValue();
            }
            throw new BadArgumentException("number has no double representation");
        }
        return Conversions.floatValueOf((Number)((Number)luaObject));
    }

    private Float castToFloat(Object luaObject) throws ClassCastException, BadArgumentException {
        Number number = (Number)luaObject;
        float result = number.floatValue();
        double doubleValue = number.doubleValue();
        if (Math.abs(doubleValue - (double)result) < 1.0) {
            return Float.valueOf(result);
        }
        throw new BadArgumentException("number has no float representation");
    }

    private Integer castToInt(Object luaObject) throws ClassCastException, BadArgumentException {
        Long result = Conversions.integerValueOf((Number)((Number)luaObject));
        if (result != null && (long)result.intValue() == result) {
            return result.intValue();
        }
        throw new BadArgumentException("number has no int representation");
    }

    private Long castToLong(Object luaObject) throws ClassCastException, BadArgumentException {
        Long result = Conversions.integerValueOf((Number)((Number)luaObject));
        if (result != null) {
            return result;
        }
        throw new BadArgumentException("number has no long representation");
    }

    @Override
    @Nullable
    public final Optional<? extends Object> toLuaOptional(@Nullable Object value) throws ConversionException {
        return Optional.ofNullable(this.toLuaNullable(value));
    }

    @Override
    @Nullable
    public final Object toLuaNullable(@Nullable Object value) throws ConversionException {
        if (value == null) {
            return null;
        }
        return this.toLua(value);
    }

    @Override
    public <J> Object toLua(J javaObject) throws ConversionException {
        Objects.requireNonNull(javaObject, "javaObject == null!");
        Class<?> javaClass = javaObject.getClass();
        JavaToLuaConverter<?> converter = this.getJavaToLuaConverter(javaClass);
        if (converter != null) {
            return converter.getLuaInstance(javaObject);
        }
        if (javaObject instanceof Map) {
            Map map = (Map)javaObject;
            DefaultTable result = new DefaultTable();
            for (Map.Entry entry : map.entrySet()) {
                result.rawset(this.toLua(entry.getKey()), this.toLua(entry.getValue()));
            }
            return result;
        }
        if (javaObject instanceof Iterable) {
            Iterable it = (Iterable)javaObject;
            DefaultTable result = new DefaultTable();
            int index = 0;
            for (Object value : it) {
                result.rawset((long)(++index), this.toLua(value));
            }
            return result;
        }
        if (javaObject instanceof class_3542) {
            class_3542 s = (class_3542)javaObject;
            return ByteString.of((String)s.method_15434());
        }
        if (javaObject instanceof Message) {
            Message m = (Message)javaObject;
            return ByteString.of((String)m.getString());
        }
        if (javaObject instanceof Enum) {
            Enum e = (Enum)javaObject;
            Object result = this.enumConverter.toLua(e);
            if (result != null) {
                return result;
            }
            return ByteString.of((String)e.name());
        }
        if (javaObject instanceof String) {
            String str = (String)javaObject;
            return ByteString.of((String)str);
        }
        if (javaObject instanceof Table) {
            return javaObject;
        }
        if (javaObject instanceof ByteString) {
            return javaObject;
        }
        if (javaObject instanceof Number) {
            return javaObject;
        }
        if (javaObject instanceof Boolean) {
            return javaObject;
        }
        throw new ConversionException(String.format("Can't convert value! Unsupported type: %s", javaObject.getClass().getName()));
    }
}

