/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.module.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Deque;
import net.sandius.rembulan.LuaRuntimeException;
import net.sandius.rembulan.runtime.ExecutionContext;
import net.sandius.rembulan.runtime.IllegalOperationAttemptException;
import net.sandius.rembulan.runtime.UnresolvedControlThrowable;
import net.wizardsoflua.event.WolEvent;
import org.jetbrains.annotations.Nullable;

public class EventQueue {
    private final ImmutableSet<String> names;
    private final Context context;
    private Deque<WolEvent> elements = new ArrayDeque<WolEvent>();
    private long waitUntil = -1L;

    public EventQueue(Iterable<String> names, Context context) {
        this.names = ImmutableSet.copyOf(names);
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context==null!");
    }

    public ImmutableSet<String> getNames() {
        return this.names;
    }

    public void pauseIfRequested(ExecutionContext context) throws IllegalOperationAttemptException, LuaRuntimeException, UnresolvedControlThrowable {
        this.context.pauseIfRequested(context);
    }

    public void stop() {
        this.context.stop(this);
    }

    public long getWaitUntil() {
        return this.waitUntil;
    }

    public void setTimeout(@Nullable Long timeout) {
        this.waitUntil = timeout != null ? this.context.getCurrentTime() + timeout : Long.MAX_VALUE;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public void clear() {
        this.elements.clear();
    }

    @Nullable
    public WolEvent latest() {
        WolEvent element = null;
        while (!this.elements.isEmpty()) {
            element = this.elements.removeFirst();
        }
        return element;
    }

    public WolEvent pop() {
        WolEvent result = this.elements.pop();
        this.stopWaitingForEvents();
        return result;
    }

    public void add(WolEvent event) {
        this.elements.addLast(event);
    }

    private void stopWaitingForEvents() {
        this.waitUntil = -1L;
    }

    public static interface Context {
        public void stop(EventQueue var1);

        public long getCurrentTime();

        public void pauseIfRequested(ExecutionContext var1) throws IllegalOperationAttemptException, LuaRuntimeException, UnresolvedControlThrowable;
    }
}

