/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.module.types;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.sandius.rembulan.ByteString;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.runtime.LuaFunction;
import net.wizardsoflua.extension.spell.api.resource.LuaTypes;
import net.wizardsoflua.extension.spell.spi.LuaToJavaConverter;
import net.wizardsoflua.lua.Converters;
import org.jetbrains.annotations.Nullable;

public class Types
implements LuaTypes {
    private final Supplier<Converters> converterSupplier;
    private final BiMap<String, Table> classes = HashBiMap.create();

    public Types(Supplier<Converters> converterSupplier) {
        this.converterSupplier = Objects.requireNonNull(converterSupplier, "converterSupplier");
    }

    public Converters getConverters() {
        return this.converterSupplier.get();
    }

    @Override
    @Nullable
    public Table getLuaClassTableForName(String luaClassName) {
        Objects.requireNonNull(luaClassName, "luaClassName == null!");
        return (Table)this.classes.get((Object)luaClassName);
    }

    @Override
    public Table registerLuaClass(String className, Table classTable) {
        Objects.requireNonNull(className, "className == null!");
        Objects.requireNonNull(classTable, "classTable == null!");
        return (Table)this.classes.put((Object)className, (Object)classTable);
    }

    public void installInto(Table env) {
        for (Map.Entry entry : this.classes.entrySet()) {
            env.rawset(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getLuaTypeNameOfLuaObject(@Nullable Object luaObject) {
        Table instanceTable;
        String result;
        if (luaObject == null) {
            return "nil";
        }
        if (luaObject instanceof Table && (result = this.getLuaClassNameOfLuaObject(instanceTable = (Table)luaObject)) != null) {
            return result;
        }
        return this.getLuaTypeName(luaObject.getClass());
    }

    @Override
    @Nullable
    public String getLuaClassNameOfLuaObject(Table luaObject) {
        Objects.requireNonNull(luaObject, "luaObject == null!");
        BiMap inverse = this.classes.inverse();
        if (inverse.containsKey((Object)luaObject)) {
            return "class";
        }
        Table metatable = luaObject.getMetatable();
        return (String)inverse.get((Object)metatable);
    }

    public String getLuaTypeNameForJavaClass(Class<?> javaClass) throws IllegalArgumentException {
        LuaToJavaConverter<?, ?> converter = this.getConverters().getLuaToJavaConverter(javaClass);
        if (converter != null) {
            return converter.getLuaClass().getName();
        }
        return this.getLuaTypeName(javaClass);
    }

    private String getLuaTypeName(Class<?> cls) {
        if (Table.class.isAssignableFrom(cls)) {
            return "table";
        }
        if (ByteString.class.isAssignableFrom(cls) || String.class.isAssignableFrom(cls)) {
            return "string";
        }
        if (Number.class.isAssignableFrom(cls)) {
            return "number";
        }
        if (Boolean.class.isAssignableFrom(cls)) {
            return "boolean";
        }
        if (LuaFunction.class.isAssignableFrom(cls)) {
            return "function";
        }
        throw new IllegalArgumentException("Unknown lua type: " + cls.getName());
    }
}

