/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.lua.table;

import java.util.Map;
import java.util.Objects;
import net.sandius.rembulan.Conversions;
import net.sandius.rembulan.Table;
import net.sandius.rembulan.impl.DefaultTable;
import net.sandius.rembulan.util.TraversableHashMap;
import net.wizardsoflua.lua.table.TableBuilder;

public class DefaultTableBuilder
implements TableBuilder {
    private final TraversableHashMap<Object, Object> entries;
    private Table metatable = null;

    private static void checkKey(Object key) {
        if (key == null || key instanceof Double && Double.isNaN((Double)key)) {
            throw new IllegalArgumentException("invalid table key: " + String.valueOf(Conversions.toHumanReadableString((Object)key)));
        }
    }

    private DefaultTableBuilder(TraversableHashMap<Object, Object> entries) {
        this.entries = Objects.requireNonNull(entries);
    }

    public DefaultTableBuilder() {
        this((TraversableHashMap<Object, Object>)new TraversableHashMap());
    }

    private static <K, V> TraversableHashMap<K, V> mapCopy(TraversableHashMap<K, V> map) {
        TraversableHashMap result = new TraversableHashMap();
        result.putAll(map);
        return result;
    }

    public DefaultTableBuilder(DefaultTableBuilder builder) {
        this(DefaultTableBuilder.mapCopy(builder.entries));
    }

    @Override
    public DefaultTableBuilder add(Object key, Object value) {
        key = Conversions.normaliseKey((Object)key);
        DefaultTableBuilder.checkKey(key);
        if (value != null) {
            this.entries.put(key, value);
        } else {
            this.entries.remove(key);
        }
        return this;
    }

    @Override
    public DefaultTableBuilder setMetatable(Table table) {
        this.metatable = table;
        return this;
    }

    public void clear() {
        this.entries.clear();
    }

    public DefaultTable build() {
        DefaultTable result = new DefaultTable();
        for (Map.Entry e : this.entries.entrySet()) {
            Object k = e.getKey();
            result.rawset(k, e.getValue());
        }
        result.setMetatable(this.metatable);
        return result;
    }
}

