/*
 * Decompiled with CFR 0.152.
 */
package net.wizardsoflua.spell;

import com.google.common.base.Throwables;
import java.util.Optional;
import net.wizardsoflua.spell.SpellException;

public class SpellExceptionFactory {
    public SpellException create(Throwable throwable) {
        String message = SpellExceptionFactory.getMessage(throwable);
        CharSequence luaStackTrace = SpellExceptionFactory.getLuaStackTrace(throwable);
        return new SpellException(message + String.valueOf(luaStackTrace), throwable);
    }

    private static String getMessage(Throwable throwable) {
        Throwable rootCause = Throwables.getRootCause((Throwable)throwable);
        String message = rootCause.getMessage();
        return Optional.ofNullable(message).orElse("Unknown error");
    }

    private static CharSequence getLuaStackTrace(Throwable throwable) {
        StackTraceElement[] stackTrace;
        Throwable rootCause = Throwables.getRootCause((Throwable)throwable);
        StringBuilder luaStackTrace = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTrace = rootCause.getStackTrace()) {
            String className = stackTraceElement.getClassName();
            int lineNumber = stackTraceElement.getLineNumber();
            if (!className.startsWith("SpellByteCode") || lineNumber < 0) continue;
            String fileName = stackTraceElement.getFileName();
            luaStackTrace.append("\n at line ").append(lineNumber).append(" of ").append(fileName);
        }
        return luaStackTrace;
    }
}

