local shearDescriptions = {
	{ species = "cow",       dropItem = "leather",      dropCount = 1, newAge = -24000, rescale = nil, dropNbt = nil },
	{ species = "chicken",   dropItem = "feather",      dropCount = 1, newAge = -24000, rescale = nil, dropNbt = nil },
	{ species = "horse",     dropItem = "leather",      dropCount = 2, newAge = -24000, rescale = nil, dropNbt = nil },
	{ species = "pig",       dropItem = "porkchop",     dropCount = 1, newAge = -24000, rescale = nil, dropNbt = nil },
	{ species = "wolf",      dropItem = "bone",         dropCount = 2, newAge = -24000, rescale = nil, dropNbt = nil },
	{ species = "goat",      dropItem = "mutton",       dropCount = 1, newAge = -24000, rescale = nil, dropNbt = nil },
	{ species = "bee",       dropItem = "honey_bottle", dropCount = 1, newAge = -24000, rescale = nil, dropNbt = nil },
	{ species = "armadillo", dropItem = "tnt",          dropCount = 1, newAge = -24000, rescale = nil, dropNbt = nil },
--	{ species = "blaze",     dropItem = "blaze_powder", dropCount = 2, newAge = -24000, rescale = nil, dropNbt = nil },
--	{ species = "creeper",   dropItem = "gunpowder",    dropCount = 5, newAge = -24000, rescale = 0.5, dropNbt = nil },
--	{ species = "drowned",   dropItem = "green_candle", dropCount = 1, newAge = -24000, rescale = nil, dropNbt = nil },
	{ species = "bat",       dropItem = "black_dye",    dropCount = 8, newAge = -24000, rescale = nil, dropNbt = nil },
	{ species = "cat",       dropItem = "potion",       dropCount = 1, newAge = -24000, rescale = nil, dropNbt = {components={["minecraft:potion_contents"]={potion="minecraft:infested"}}} },
	{ species = "camel",     dropItem = "potion",       dropCount = 1, newAge = -24000, rescale = nil, dropNbt = {components={["minecraft:potion_contents"]={potion="minecraft:water_breathing"}}} },
}


function shearHandler(event)
	if event.hand ~= "MAIN_HAND" then return true; end
	if not event.hitResult then return true; end
	if not event.entity then return true; end
	if event.entity.baby == true then return true; end -- still a baby
	if event.entity.age <= 0 then return true; end -- broken?  Does not update alongside nbt data.
	--if event.entity.extra[shawn] then return true; end -- permanent baby
	if not event.player.mainHandItem then return true; end
	if event.player.mainHandItem.name ~= "Shears" then return true; end
	if not event.entity.type then return true; end
	if not event.entity.type.id then return true; end
	
	-- print("Sheared a " .. event.entity.name)
	--print(inspect(event.entity, {depth=2}))

	if event.entity.type and event.entity.type.id == "player" then
		shearAPlayer(event)
		damageShearsInHand(event.player)
		return true	
	end

	for _, sd in pairs(shearDescriptions) do
		if event.entity.type.id == sd.species then
			if sd.dropItem then 
				local lootitem = Item:new(sd.dropItem)
				lootitem.count = sd.dropCount
				if sd.dropNbt then lootitem:putNbt(sd.dropNbt); end
				event.entity:dropItem(lootitem, 1)
			end
			
			if sd.rescale then spell:executeSilent("/attribute " .. event.entity.uuid .. " minecraft:scale base set " .. sd.rescale); end
			event.entity:putNbt({Age = sd.newAge})
			--event.entity:putExtra({shawn = true }) -- Mark as youngling to avoid double-shearing.  Not every entity has an age we can use.
			
			damageShearsInHand(event.player)
		end
	end
	
	return true
end


function shearAPlayer(event)
	local playername = event.entity.name
	if not playername then return; end
	if event.entity.extra.shawn and event.entity.extra.shawn == true then return; end
	
	local newscale = 0.9
	local dropitem = Item:new("usefulfood:glow_berries_jam_pancake")
	
	if playername == "DoctorKaze" then
		newscale = 1.1
		dropitem = Item:new("bread")
	end
	
	spell:execute("/attribute "..playername.." minecraft:scale base set "..str(newscale))
	event.entity:dropItem(dropitem,1)
	event.entity:putExtra({shawn = true })
end

function damageShearsInHand(player)
	local handitem = player.mainHandItem
	if not handitem or handitem.name ~= "Shears" then return; end

	handitem.damage = handitem.damage + 1 
	spell.pos = player.pos
	spell:executeSilent("/playsound minecraft:entity.sheep.shear player @a ~ ~ ~")
	-- if handitem.damage >= handitem.maxDamage then print("Break!"); end -- TODO worm out how to break item
end

spell:intercept({"PlayerUseEntityEvent"}, shearHandler)