/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.config.ui;

public class ConfigAnnotations {

    public static class Execute
    implements ConfigAnnotation {
        private final String command;

        private Execute(String command) {
            this.command = command;
        }

        public static Execute run(String command) {
            return new Execute(command);
        }

        @Override
        public String getName() {
            return "Execute";
        }

        @Override
        public String getValue() {
            return this.command;
        }
    }

    public static interface ConfigAnnotation {
        public String getName();

        default public String getValue() {
            return null;
        }

        default public String asComment() {
            String comment = "[@cui:" + this.getName();
            String value = this.getValue();
            if (value != null) {
                comment = comment + ":" + value;
            }
            comment = comment + "]";
            return comment;
        }
    }

    public static enum RequiresRelog implements ConfigAnnotation
    {
        TRUE;


        @Override
        public String getName() {
            return "RequiresRelog";
        }
    }

    public static enum RequiresRestart implements ConfigAnnotation
    {
        CLIENT("client"),
        SERVER("server"),
        BOTH("both");

        private final String value;

        private RequiresRestart(String value) {
            this.value = value;
        }

        @Override
        public String getName() {
            return "RequiresReload";
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum IntDisplay implements ConfigAnnotation
    {
        HEX("#"),
        ZERO_X("0x"),
        ZERO_B("0b");

        private final String value;

        private IntDisplay(String value) {
            this.value = value;
        }

        @Override
        public String getName() {
            return "IntDisplay";
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

