/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.animation;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public interface Force {
    public float get(float var1, float var2, float var3);

    public boolean finished();

    @Environment(value=EnvType.CLIENT)
    public static class Static
    implements Force {
        float force;

        public Static(float force) {
            this.force = force;
        }

        @Override
        public float get(float mass, float value, float speed) {
            return this.force;
        }

        @Override
        public boolean finished() {
            return false;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class OverTime
    implements Force {
        int timeRemaining;
        float f;

        public OverTime(int time, float totalAcceleration) {
            this.timeRemaining = time;
            this.f = totalAcceleration / (float)time;
        }

        @Override
        public float get(float mass, float value, float speed) {
            --this.timeRemaining;
            return this.f;
        }

        @Override
        public boolean finished() {
            return this.timeRemaining <= 0;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Impulse
    implements Force {
        float force;

        public Impulse(float force) {
            this.force = force;
        }

        @Override
        public float get(float mass, float value, float speed) {
            return this.force;
        }

        @Override
        public boolean finished() {
            return true;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Zeroing
    implements Force {
        final float g;

        public Zeroing(float g) {
            this.g = g / 20.0f;
        }

        @Override
        public float get(float mass, float value, float speed) {
            return -Math.signum(value) * this.g * mass;
        }

        @Override
        public boolean finished() {
            return false;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Drag
    implements Force {
        final float dragFactor;

        public Drag(float dragFactor) {
            this.dragFactor = dragFactor;
        }

        @Override
        public float get(float mass, float value, float speed) {
            return -speed * this.dragFactor;
        }

        @Override
        public boolean finished() {
            return false;
        }
    }
}

