/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.rei;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.compat.rei.ReiExclusionZones;
import com.zurrtum.create.client.compat.rei.category.AutoCompactingCategory;
import com.zurrtum.create.client.compat.rei.category.AutoMixingCategory;
import com.zurrtum.create.client.compat.rei.category.BlockCuttingCategory;
import com.zurrtum.create.client.compat.rei.category.CompactingCategory;
import com.zurrtum.create.client.compat.rei.category.CrushingCategory;
import com.zurrtum.create.client.compat.rei.category.DeployingCategory;
import com.zurrtum.create.client.compat.rei.category.DrainingCategory;
import com.zurrtum.create.client.compat.rei.category.FanBlastingCategory;
import com.zurrtum.create.client.compat.rei.category.FanHauntingCategory;
import com.zurrtum.create.client.compat.rei.category.FanSmokingCategory;
import com.zurrtum.create.client.compat.rei.category.FanWashingCategory;
import com.zurrtum.create.client.compat.rei.category.ManualApplicationCategory;
import com.zurrtum.create.client.compat.rei.category.MechanicalCraftingCategory;
import com.zurrtum.create.client.compat.rei.category.MillingCategory;
import com.zurrtum.create.client.compat.rei.category.MixingCategory;
import com.zurrtum.create.client.compat.rei.category.MysteriousItemConversionCategory;
import com.zurrtum.create.client.compat.rei.category.PotionCategory;
import com.zurrtum.create.client.compat.rei.category.PressingCategory;
import com.zurrtum.create.client.compat.rei.category.SandpaperPolishingCategory;
import com.zurrtum.create.client.compat.rei.category.SawingCategory;
import com.zurrtum.create.client.compat.rei.category.SequencedAssemblyCategory;
import com.zurrtum.create.client.compat.rei.category.SpoutFillingCategory;
import com.zurrtum.create.client.compat.rei.display.MysteriousItemConversionDisplay;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.compat.rei.display.DrainingDisplay;
import com.zurrtum.create.compat.rei.display.SpoutFillingDisplay;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlock;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZonesProvider;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.registry.display.DisplayConsumer;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.client.displays.ClientsidedCraftingDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1935;

@Environment(value=EnvType.CLIENT)
public class ReiClientPlugin
implements REIClientPlugin {
    public static final CategoryIdentifier<MysteriousItemConversionDisplay> MYSTERY_CONVERSION = CategoryIdentifier.of((String)"create", (String)"mystery_conversion");

    private <T extends Display> Consumer<CategoryRegistry.CategoryConfiguration<T>> config(class_1935 ... item) {
        EntryStack[] workstations = new EntryStack[item.length];
        for (int i = 0; i < item.length; ++i) {
            workstations[i] = EntryStacks.of((class_1935)item[i]);
        }
        return config -> {
            if (workstations.length > 0) {
                config.addWorkstations(workstations);
            }
            config.setPlusButtonArea(bounds -> new Rectangle(bounds.getMaxX() - 16, bounds.getMinY() + 6, 10, 10));
        };
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new AutoCompactingCategory(), this.config(new class_1935[]{AllItems.MECHANICAL_PRESS, AllItems.BASIN}));
        registry.add((DisplayCategory)new CompactingCategory(), this.config(new class_1935[]{AllItems.MECHANICAL_PRESS, AllItems.BASIN}));
        registry.add((DisplayCategory)new PressingCategory(), this.config(new class_1935[]{AllItems.MECHANICAL_PRESS}));
        registry.add((DisplayCategory)new AutoMixingCategory(), this.config(new class_1935[]{AllItems.MECHANICAL_MIXER, AllItems.BASIN}));
        registry.add((DisplayCategory)new MixingCategory(), this.config(new class_1935[]{AllItems.MECHANICAL_MIXER, AllItems.BASIN}));
        registry.add((DisplayCategory)new MillingCategory(), this.config(new class_1935[]{AllItems.MILLSTONE}));
        registry.add((DisplayCategory)new SawingCategory(), this.config(new class_1935[]{AllItems.MECHANICAL_SAW}));
        registry.add((DisplayCategory)new CrushingCategory(), this.config(new class_1935[]{AllItems.CRUSHING_WHEEL}));
        registry.add((DisplayCategory)new MysteriousItemConversionCategory(), this.config(new class_1935[0]));
        registry.add((DisplayCategory)new ManualApplicationCategory(), this.config(new class_1935[0]));
        registry.add((DisplayCategory)new DeployingCategory(), this.config(new class_1935[]{AllItems.DEPLOYER, AllItems.DEPOT, AllItems.BELT_CONNECTOR}));
        registry.add((DisplayCategory)new DrainingCategory(), this.config(new class_1935[]{AllItems.ITEM_DRAIN}));
        registry.add((DisplayCategory)new MechanicalCraftingCategory(), this.config(new class_1935[]{AllItems.MECHANICAL_CRAFTER}));
        registry.add((DisplayCategory)new SpoutFillingCategory(), this.config(new class_1935[]{AllItems.SPOUT}));
        registry.add((DisplayCategory)new SandpaperPolishingCategory(), this.config(new class_1935[]{AllItems.SAND_PAPER, AllItems.RED_SAND_PAPER}));
        registry.add((DisplayCategory)new SequencedAssemblyCategory(), this.config(new class_1935[0]));
        registry.add((DisplayCategory)new BlockCuttingCategory(), this.config(new class_1935[]{AllItems.MECHANICAL_SAW}));
        registry.add((DisplayCategory)new FanBlastingCategory(), this.config(new class_1935[]{AllItems.ENCASED_FAN}));
        registry.add((DisplayCategory)new FanHauntingCategory(), this.config(new class_1935[]{AllItems.ENCASED_FAN}));
        registry.add((DisplayCategory)new FanSmokingCategory(), this.config(new class_1935[]{AllItems.ENCASED_FAN}));
        registry.add((DisplayCategory)new FanWashingCategory(), this.config(new class_1935[]{AllItems.ENCASED_FAN}));
        registry.add((DisplayCategory)new PotionCategory(), this.config(new class_1935[]{AllItems.MECHANICAL_MIXER, AllItems.BASIN}));
    }

    public void registerDisplays(DisplayRegistry registry) {
        registry.add((Display)new MysteriousItemConversionDisplay((class_1792)AllItems.EMPTY_BLAZE_BURNER, (class_1792)AllItems.BLAZE_BURNER));
        registry.add((Display)new MysteriousItemConversionDisplay((class_1792)AllItems.PECULIAR_BELL, (class_1792)AllItems.HAUNTED_BELL));
        ReiClientPlugin.registerToolboxRecipes(registry);
        EntryRegistry entrys = EntryRegistry.getInstance();
        SpoutFillingDisplay.register(entrys.getEntryStacks().filter(stack -> Objects.equals(stack.getType(), VanillaEntryTypes.ITEM)), entrys.getEntryStacks().filter(stack -> Objects.equals(stack.getType(), VanillaEntryTypes.FLUID)), (DisplayConsumer)registry);
        DrainingDisplay.register(entrys.getEntryStacks().filter(stack -> Objects.equals(stack.getType(), VanillaEntryTypes.ITEM)), (DisplayConsumer)registry);
    }

    private static void registerToolboxRecipes(DisplayRegistry registry) {
        EntryIngredient ingredient = EntryIngredients.ofItemTag(AllItemTags.TOOLBOXES);
        for (class_1767 color : class_1767.values()) {
            registry.add((Display)new ClientsidedCraftingDisplay.Shapeless(List.of(ingredient, EntryIngredients.of((class_1935)class_1769.method_7803((class_1767)color))), List.of(EntryIngredients.of((class_1935)ToolboxBlock.getColorBlock(color))), Optional.empty()));
        }
    }

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(AbstractSimiContainerScreen.class, (ExclusionZonesProvider)new ReiExclusionZones());
    }
}

