/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.catnip.placement.PlacementClient;
import com.zurrtum.create.client.content.contraptions.actors.trainControls.ControlsHandler;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.utility.ControlsUtil;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.c2s.HonkPacket;
import com.zurrtum.create.infrastructure.packet.c2s.TrainHUDUpdatePacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class TrainHUD {
    static LerpedFloat displayedSpeed = LerpedFloat.linear();
    static LerpedFloat displayedThrottle = LerpedFloat.linear();
    static LerpedFloat displayedPromptSize = LerpedFloat.linear();
    static Double editedThrottle = null;
    static int hudPacketCooldown = 5;
    static int honkPacketCooldown = 5;
    public static class_2561 currentPrompt;
    public static boolean currentPromptShadow;
    public static int promptKeepAlive;
    static boolean usedToHonk;

    public static void tick(class_310 mc) {
        if (promptKeepAlive > 0) {
            --promptKeepAlive;
        } else {
            currentPrompt = null;
        }
        displayedPromptSize.chase(currentPrompt != null ? (double)(mc.field_1772.method_27525((class_5348)currentPrompt) + 17) : 0.0, 0.5, LerpedFloat.Chaser.EXP);
        displayedPromptSize.tickChaser();
        Carriage carriage = TrainHUD.getCarriage();
        if (carriage == null) {
            return;
        }
        Train train = carriage.train;
        double value = Math.abs(train.speed) / (double)(train.maxSpeed() * AllConfigs.server().trains.manualTrainSpeedModifier.getF());
        value = class_3532.method_15350((double)(value + (double)0.05f), (double)0.0, (double)1.0);
        displayedSpeed.chase((float)((int)(value * 18.0)) / 18.0f, 0.5, LerpedFloat.Chaser.EXP);
        displayedSpeed.tickChaser();
        displayedThrottle.chase(editedThrottle != null ? editedThrottle : train.throttle, 0.75, LerpedFloat.Chaser.EXP);
        displayedThrottle.tickChaser();
        boolean isSprintKeyPressed = ControlsUtil.isActuallyPressed(mc.field_1690.field_1867);
        if (isSprintKeyPressed && honkPacketCooldown-- <= 0) {
            train.determineHonk((class_1937)mc.field_1687);
            if (train.lowHonk != null) {
                mc.field_1724.field_3944.method_52787((class_2596)new HonkPacket(train, true));
                honkPacketCooldown = 5;
                usedToHonk = true;
            }
        }
        if (!isSprintKeyPressed && usedToHonk) {
            mc.field_1724.field_3944.method_52787((class_2596)new HonkPacket(train, false));
            honkPacketCooldown = 0;
            usedToHonk = false;
        }
        if (editedThrottle == null) {
            return;
        }
        if (class_3532.method_20390((double)editedThrottle, (double)train.throttle)) {
            editedThrottle = null;
            hudPacketCooldown = 5;
            return;
        }
        if (hudPacketCooldown-- <= 0) {
            mc.field_1724.field_3944.method_52787((class_2596)new TrainHUDUpdatePacket(train, editedThrottle));
            hudPacketCooldown = 5;
        }
    }

    private static Carriage getCarriage() {
        AbstractContraptionEntity abstractContraptionEntity = ControlsHandler.getContraption();
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return null;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
        return cce.getCarriage();
    }

    public static void renderOverlay(class_310 mc, class_332 guiGraphics, class_9779 deltaTracker) {
        float partialTicks = deltaTracker.method_60637(false);
        AbstractContraptionEntity abstractContraptionEntity = ControlsHandler.getContraption();
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
        Carriage carriage = cce.getCarriage();
        if (carriage == null) {
            return;
        }
        class_1297 cameraEntity = mc.method_1560();
        if (cameraEntity == null) {
            return;
        }
        class_2338 localPos = ControlsHandler.getControlsPos();
        if (localPos == null) {
            return;
        }
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate((float)(guiGraphics.method_51421() / 2 - 91), (float)(guiGraphics.method_51443() - 29));
        AllGuiTextures.TRAIN_HUD_FRAME.render(guiGraphics, -2, 1);
        AllGuiTextures.TRAIN_HUD_SPEED_BG.render(guiGraphics, 0, 0);
        int w = (int)((float)AllGuiTextures.TRAIN_HUD_SPEED.getWidth() * displayedSpeed.getValue(partialTicks));
        int h = AllGuiTextures.TRAIN_HUD_SPEED.getHeight();
        guiGraphics.method_25290(class_10799.field_56883, AllGuiTextures.TRAIN_HUD_SPEED.location, 0, 0, (float)AllGuiTextures.TRAIN_HUD_SPEED.getStartX(), (float)AllGuiTextures.TRAIN_HUD_SPEED.getStartY(), w, h, 256, 256);
        int promptSize = (int)displayedPromptSize.getValue(partialTicks);
        if (promptSize > 1) {
            poseStack.pushMatrix();
            poseStack.translate((float)promptSize / -2.0f + 91.0f, -27.0f);
            AllGuiTextures.TRAIN_PROMPT_L.render(guiGraphics, -3, 0);
            AllGuiTextures.TRAIN_PROMPT_R.render(guiGraphics, promptSize, 0);
            guiGraphics.method_25290(class_10799.field_56883, AllGuiTextures.TRAIN_PROMPT.location, 0, 0, (float)AllGuiTextures.TRAIN_PROMPT.getStartX() + (128.0f - (float)promptSize / 2.0f), (float)AllGuiTextures.TRAIN_PROMPT.getStartY(), promptSize, AllGuiTextures.TRAIN_PROMPT.getHeight(), 256, 256);
            poseStack.popMatrix();
            class_327 font = mc.field_1772;
            if (currentPrompt != null && font.method_27525((class_5348)currentPrompt) < promptSize - 10) {
                poseStack.pushMatrix();
                poseStack.translate((float)font.method_27525((class_5348)currentPrompt) / -2.0f + 82.0f, -27.0f);
                guiGraphics.method_51439(font, currentPrompt, 9, 4, -11252411, currentPromptShadow);
                poseStack.popMatrix();
            }
        }
        AllGuiTextures.TRAIN_HUD_DIRECTION.render(guiGraphics, 77, -20);
        w = (int)((float)AllGuiTextures.TRAIN_HUD_THROTTLE.getWidth() * (1.0f - displayedThrottle.getValue(partialTicks)));
        int invW = AllGuiTextures.TRAIN_HUD_THROTTLE.getWidth() - w;
        guiGraphics.method_25290(class_10799.field_56883, AllGuiTextures.TRAIN_HUD_THROTTLE.location, invW, 0, (float)(AllGuiTextures.TRAIN_HUD_THROTTLE.getStartX() + invW), (float)AllGuiTextures.TRAIN_HUD_THROTTLE.getStartY(), w, h, 256, 256);
        AllGuiTextures.TRAIN_HUD_THROTTLE_POINTER.render(guiGraphics, Math.max(1, AllGuiTextures.TRAIN_HUD_THROTTLE.getWidth() - w) - 3, -2);
        class_3499.class_3501 info = cce.getContraption().getBlocks().get(localPos);
        class_2350 initialOrientation = cce.getInitialOrientation().method_10160();
        boolean inverted = false;
        if (info != null && info.comp_1342().method_28498((class_2769)ControlsBlock.field_11177)) {
            inverted = !((class_2350)info.comp_1342().method_11654((class_2769)ControlsBlock.field_11177)).equals((Object)initialOrientation);
        }
        boolean reversing = ControlsHandler.currentlyPressed.contains(1);
        inverted ^= reversing;
        int angleOffset = (ControlsHandler.currentlyPressed.contains(2) ? -45 : 0) + (ControlsHandler.currentlyPressed.contains(3) ? 45 : 0);
        if (reversing) {
            angleOffset *= -1;
        }
        float snapSize = 22.5f;
        float diff = AngleHelper.getShortestAngleDiff(cameraEntity.method_36454(), cce.yaw) + (float)(inverted ? -90 : 90);
        if (Math.abs(diff) < 60.0f) {
            diff = 0.0f;
        }
        float angle = diff + (float)angleOffset;
        float snappedAngle = snapSize * (float)Math.round(angle / snapSize) % 360.0f;
        poseStack.translate(91.0f, -9.0f);
        poseStack.scale(0.925f, 0.925f);
        PlacementClient.textured(guiGraphics, 0.0f, 0.0f, 1.0f, snappedAngle);
        poseStack.popMatrix();
    }

    public static boolean onScroll(double delta) {
        Carriage carriage = TrainHUD.getCarriage();
        if (carriage == null) {
            return false;
        }
        double prevThrottle = editedThrottle == null ? carriage.train.throttle : editedThrottle;
        editedThrottle = class_3532.method_15350((double)(prevThrottle + (double)((float)(delta > 0.0 ? 1 : -1) / 18.0f)), (double)0.0555555559694767, (double)1.0);
        return true;
    }

    static {
        promptKeepAlive = 0;
    }
}

