/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.observer;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrackRenders;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.TickableVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleTickableVisual;
import com.zurrtum.create.content.trains.observer.TrackObserver;
import com.zurrtum.create.content.trains.observer.TrackObserverBlockEntity;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class TrackObserverVisual
extends AbstractBlockEntityVisual<TrackObserverBlockEntity>
implements SimpleTickableVisual {
    private final TransformedInstance overlay;
    private class_2338 oldTargetPos;

    public TrackObserverVisual(VisualizationContext ctx, TrackObserverBlockEntity blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
        this.overlay = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.TRACK_OBSERVER_OVERLAY)).createInstance();
        this.setupVisual();
    }

    @Override
    public void tick(TickableVisual.Context context) {
        this.setupVisual();
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight(this.overlay);
    }

    @Override
    protected void _delete() {
        this.overlay.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept(this.overlay);
    }

    private void setupVisual() {
        TrackTargetingBehaviour<TrackObserver> target = ((TrackObserverBlockEntity)this.blockEntity).edgePoint;
        class_2338 targetPosition = target.getGlobalPosition();
        class_1937 level = ((TrackObserverBlockEntity)this.blockEntity).method_10997();
        class_2680 trackState = level.method_8320(targetPosition);
        class_2248 block = trackState.method_26204();
        if (!(block instanceof ITrackBlock)) {
            this.overlay.setZeroTransform().setChanged();
            return;
        }
        ITrackBlock trackBlock = (ITrackBlock)block;
        if (!targetPosition.equals((Object)this.oldTargetPos)) {
            this.oldTargetPos = targetPosition;
            this.overlay.setIdentityTransform().translate((class_2382)targetPosition.method_10059(this.renderOrigin()));
            TrackBlockRenderer renderer = AllTrackRenders.get(trackBlock);
            if (renderer != null) {
                TrackTargetingBehaviour.RenderedTrackOverlayType type = TrackTargetingBehaviour.RenderedTrackOverlayType.OBSERVER;
                renderer.prepareTrackOverlay(this.overlay, (class_1922)level, targetPosition, trackState, target.getTargetBezier(), target.getTargetDirection(), type);
            }
            this.overlay.setChanged();
        }
    }
}

