/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import com.zurrtum.create.client.flywheel.lib.model.SimpleQuadMesh;
import com.zurrtum.create.client.flywheel.lib.vertex.NoOverlayVertexView;
import java.nio.ByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public final class MeshHelper {
    private MeshHelper() {
    }

    public static SimpleQuadMesh blockVerticesToMesh(class_9801 data, @Nullable String meshDescriptor) {
        class_9801.class_4574 drawState = data.method_60822();
        int vertexCount = drawState.comp_750();
        long srcStride = drawState.comp_749().getVertexSize();
        NoOverlayVertexView vertexView = new NoOverlayVertexView();
        long dstStride = vertexView.stride();
        ByteBuffer src = data.method_60818();
        MemoryBlock dst = MemoryBlock.mallocTracked((long)vertexCount * dstStride);
        long srcPtr = MemoryUtil.memAddress((ByteBuffer)src);
        long dstPtr = dst.ptr();
        long bytesToCopy = Math.min(dstStride, 31L);
        for (int i = 0; i < vertexCount; ++i) {
            MemoryUtil.memCopy((long)(srcPtr + srcStride * (long)i), (long)(dstPtr + dstStride * (long)i), (long)bytesToCopy);
        }
        vertexView.ptr(dstPtr);
        vertexView.vertexCount(vertexCount);
        vertexView.nativeMemoryOwner(dst);
        return new SimpleQuadMesh(vertexView, meshDescriptor);
    }
}

