/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.part;

import com.zurrtum.create.client.flywheel.lib.math.DataPacker;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4588;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class VertexWriter
implements class_4588 {
    private static final int STRIDE = 23;
    private MemoryBlock data = MemoryBlock.malloc(2944L);
    private int vertexCount;
    private boolean filledTexture = true;
    private boolean filledNormal = true;

    public class_4588 method_22912(float x, float y, float z) {
        this.endLastVertex();
        ++this.vertexCount;
        long byteSize = this.vertexCount * 23;
        long capacity = this.data.size();
        if (byteSize > capacity) {
            this.data = this.data.realloc(capacity * 2L);
        }
        this.filledTexture = false;
        this.filledNormal = false;
        long ptr = this.vertexPtr();
        MemoryUtil.memPutFloat((long)ptr, (float)x);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)z);
        return this;
    }

    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        return this;
    }

    public class_4588 method_22913(float u, float v) {
        if (!this.filledTexture) {
            long ptr = this.vertexPtr();
            MemoryUtil.memPutFloat((long)(ptr + 12L), (float)u);
            MemoryUtil.memPutFloat((long)(ptr + 16L), (float)v);
            this.filledTexture = true;
        }
        return this;
    }

    public class_4588 method_60796(int u, int v) {
        return this;
    }

    public class_4588 method_22921(int u, int v) {
        return this;
    }

    public class_4588 method_22914(float x, float y, float z) {
        if (!this.filledNormal) {
            long ptr = this.vertexPtr();
            MemoryUtil.memPutByte((long)(ptr + 20L), (byte)DataPacker.packNormI8(x));
            MemoryUtil.memPutByte((long)(ptr + 21L), (byte)DataPacker.packNormI8(y));
            MemoryUtil.memPutByte((long)(ptr + 22L), (byte)DataPacker.packNormI8(z));
            this.filledNormal = true;
        }
        return this;
    }

    private long vertexPtr() {
        return this.data.ptr() + (long)((this.vertexCount - 1) * 23);
    }

    private void endLastVertex() {
        if (!(this.vertexCount == 0 || this.filledTexture && this.filledNormal)) {
            throw new IllegalStateException("Missing elements in vertex");
        }
    }

    public MemoryBlock copyDataAndReset() {
        this.endLastVertex();
        MemoryBlock dataCopy = MemoryBlock.mallocTracked(this.vertexCount * 23);
        this.data.copyTo(dataCopy);
        this.vertexCount = 0;
        this.filledTexture = true;
        this.filledNormal = true;
        return dataCopy;
    }
}

