/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1936;

@Environment(value=EnvType.CLIENT)
public final class LevelAttached<T> {
    private static final ConcurrentLinkedDeque<WeakReference<LevelAttached<?>>> ALL = new ConcurrentLinkedDeque();
    private static final Cleaner CLEANER = Cleaner.create();
    private final LoadingCache<class_1936, T> cache;

    public LevelAttached(final Function<class_1936, T> factory, Consumer<T> finalizer) {
        WeakReference thisRef = new WeakReference(this);
        ALL.add(thisRef);
        this.cache = CacheBuilder.newBuilder().removalListener(n -> finalizer.accept(n.getValue())).build(new CacheLoader<class_1936, T>(this){

            public T load(class_1936 key) {
                return factory.apply(key);
            }
        });
        CLEANER.register(this, new CleaningAction(thisRef, this.cache));
    }

    public LevelAttached(Function<class_1936, T> factory) {
        this(factory, t -> {});
    }

    public static void invalidateLevel(class_1936 level) {
        Iterator<WeakReference<LevelAttached<?>>> iterator = ALL.iterator();
        while (iterator.hasNext()) {
            LevelAttached attached = (LevelAttached)iterator.next().get();
            if (attached == null) {
                iterator.remove();
                continue;
            }
            attached.remove(level);
        }
    }

    public T get(class_1936 level) {
        return (T)this.cache.getUnchecked((Object)level);
    }

    public void remove(class_1936 level) {
        this.cache.invalidate((Object)level);
    }

    public T refresh(class_1936 level) {
        this.remove(level);
        return this.get(level);
    }

    public void reset() {
        this.cache.invalidateAll();
    }

    @Environment(value=EnvType.CLIENT)
    private static class CleaningAction
    implements Runnable {
        private final WeakReference<LevelAttached<?>> ref;
        private final LoadingCache<class_1936, ?> cache;

        private CleaningAction(WeakReference<LevelAttached<?>> ref, LoadingCache<class_1936, ?> cache) {
            this.ref = ref;
            this.cache = cache;
        }

        @Override
        public void run() {
            ALL.remove(this.ref);
            this.cache.invalidateAll();
        }
    }
}

