/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.vertex;

import com.zurrtum.create.client.flywheel.api.vertex.MutableVertexList;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public interface VertexView
extends MutableVertexList {
    public long ptr();

    public void ptr(long var1);

    public void vertexCount(int var1);

    public long stride();

    @Nullable
    public Object nativeMemoryOwner();

    public void nativeMemoryOwner(@Nullable Object var1);

    default public void load(MemoryBlock data) {
        long stride;
        long bytes = data.size();
        if (bytes % (stride = this.stride()) != 0L) {
            throw new IllegalArgumentException("MemoryBlock contains non-whole amount of vertices!");
        }
        int vertexCount = (int)(bytes / stride);
        this.ptr(data.ptr());
        this.vertexCount(vertexCount);
        this.nativeMemoryOwner(data);
    }

    @Override
    default public void write(MutableVertexList dst, int srcIndex, int dstIndex) {
        if (dst.getClass() == this.getClass()) {
            long stride = this.stride();
            long dstPtr = ((VertexView)dst).ptr();
            MemoryUtil.memCopy((long)(this.ptr() + (long)srcIndex * stride), (long)(dstPtr + (long)dstIndex * stride), (long)stride);
        } else {
            MutableVertexList.super.write(dst, srcIndex, dstIndex);
        }
    }

    @Override
    default public void write(MutableVertexList dst, int srcStartIndex, int dstStartIndex, int vertexCount) {
        if (dst.getClass() == this.getClass()) {
            long stride = this.stride();
            long dstPtr = ((VertexView)dst).ptr();
            MemoryUtil.memCopy((long)(this.ptr() + (long)srcStartIndex * stride), (long)(dstPtr + (long)dstStartIndex * stride), (long)((long)vertexCount * stride));
        } else {
            MutableVertexList.super.write(dst, srcStartIndex, dstStartIndex, vertexCount);
        }
    }

    @Override
    default public void writeAll(MutableVertexList dst) {
        if (dst.getClass() == this.getClass()) {
            long stride = this.stride();
            long dstPtr = ((VertexView)dst).ptr();
            MemoryUtil.memCopy((long)this.ptr(), (long)dstPtr, (long)((long)Math.min(this.vertexCount(), dst.vertexCount()) * stride));
        } else {
            MutableVertexList.super.writeAll(dst);
        }
    }
}

