/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.visual.util;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class InstanceRecycler<I extends Instance> {
    private final Supplier<I> factory;
    private final List<I> instances = new ArrayList<I>();
    private int count;

    public InstanceRecycler(Supplier<I> factory) {
        this.factory = factory;
    }

    public void resetCount() {
        this.count = 0;
    }

    public I get() {
        int lastCount;
        if ((lastCount = this.count++) < this.instances.size()) {
            return (I)((Instance)this.instances.get(lastCount));
        }
        Instance out = (Instance)this.factory.get();
        this.instances.add(out);
        return (I)out;
    }

    public void discardExtra() {
        int size = this.instances.size();
        if (this.count == size) {
            return;
        }
        List<I> extra = this.instances.subList(this.count, size);
        extra.forEach(Instance::delete);
        extra.clear();
    }

    public void delete() {
        this.instances.forEach(Instance::delete);
        this.instances.clear();
    }
}

