/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.visualization;

import com.zurrtum.create.client.flywheel.api.visual.Effect;
import com.zurrtum.create.client.flywheel.api.visualization.BlockEntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.EntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizerRegistry;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class VisualizationHelper {
    private VisualizationHelper() {
    }

    public static void queueAdd(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }
        manager.effects().queueAdd(effect);
    }

    public static void queueRemove(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }
        manager.effects().queueRemove(effect);
    }

    public static void queueUpdate(class_2586 blockEntity) {
        class_1937 level = blockEntity.method_10997();
        VisualizationManager manager = VisualizationManager.get((class_1936)level);
        if (manager == null) {
            return;
        }
        manager.blockEntities().queueUpdate(blockEntity);
    }

    public static void queueUpdate(class_1297 entity) {
        class_1937 level = entity.method_73183();
        VisualizationManager manager = VisualizationManager.get((class_1936)level);
        if (manager == null) {
            return;
        }
        manager.entities().queueUpdate(entity);
    }

    public static void queueUpdate(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }
        manager.effects().queueUpdate(effect);
    }

    @Nullable
    public static <T extends class_2586> BlockEntityVisualizer<? super T> getVisualizer(T blockEntity) {
        return VisualizerRegistry.getVisualizer(blockEntity.method_11017());
    }

    @Nullable
    public static <T extends class_1297> EntityVisualizer<? super T> getVisualizer(T entity) {
        return VisualizerRegistry.getVisualizer(entity.method_5864());
    }

    public static <T extends class_2586> boolean canVisualize(T blockEntity) {
        return VisualizationHelper.getVisualizer(blockEntity) != null;
    }

    public static <T extends class_1297> boolean canVisualize(T entity) {
        return VisualizationHelper.getVisualizer(entity) != null;
    }

    public static <T extends class_2586> boolean skipVanillaRender(T blockEntity) {
        BlockEntityVisualizer<T> visualizer = VisualizationHelper.getVisualizer(blockEntity);
        if (visualizer == null) {
            return false;
        }
        return visualizer.skipVanillaRender(blockEntity);
    }

    public static <T extends class_1297> boolean skipVanillaRender(T entity) {
        EntityVisualizer<T> visualizer = VisualizationHelper.getVisualizer(entity);
        if (visualizer == null) {
            return false;
        }
        return visualizer.skipVanillaRender(entity);
    }

    public static Iterator<class_1297> skipVanillaRender(class_638 world, Iterator<class_1297> iterator) {
        if (VisualizationManager.supportsVisualization((class_1936)world)) {
            return new EntitySkipIterator(iterator);
        }
        return iterator;
    }

    public static <T extends class_2586> boolean tryAddBlockEntity(T blockEntity) {
        class_1937 level = blockEntity.method_10997();
        VisualizationManager manager = VisualizationManager.get((class_1936)level);
        if (manager == null) {
            return false;
        }
        BlockEntityVisualizer<T> visualizer = VisualizationHelper.getVisualizer(blockEntity);
        if (visualizer == null) {
            return false;
        }
        manager.blockEntities().queueAdd(blockEntity);
        return visualizer.skipVanillaRender(blockEntity);
    }

    @Environment(value=EnvType.CLIENT)
    public static class EntitySkipIterator
    implements Iterator<class_1297> {
        private final Iterator<class_1297> iterator;
        private class_1297 next;

        public EntitySkipIterator(Iterator<class_1297> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                class_1297 entity = this.iterator.next();
                if (VisualizationHelper.skipVanillaRender(entity)) continue;
                this.next = entity;
                return true;
            }
            return false;
        }

        @Override
        public class_1297 next() {
            if (this.hasNext()) {
                class_1297 entity = this.next;
                this.next = null;
                return entity;
            }
            throw new NoSuchElementException();
        }
    }
}

