/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.fan.AirCurrent;
import com.zurrtum.create.content.kinetics.fan.IAirCurrentSource;
import com.zurrtum.create.content.kinetics.fan.processing.FanProcessingType;
import com.zurrtum.create.infrastructure.particle.AirFlowParticleData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_708;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class AirFlowParticle
extends class_708 {
    private final IAirCurrentSource source;
    private final Access access = new Access();

    protected AirFlowParticle(class_638 world, IAirCurrentSource source, double x, double y, double z, class_4002 sprite, class_5819 random) {
        super(world, x, y, z, sprite, random.method_43057() * 0.5f);
        this.source = source;
        this.field_17867 *= 0.75f;
        this.field_3847 = 40;
        this.field_3862 = false;
        this.selectSprite(7);
        class_243 offset = VecHelper.offsetRandomly(class_243.field_1353, random, 0.25f);
        this.method_3063(x + offset.field_1352, y + offset.field_1351, z + offset.field_1350);
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.method_3093(0xEEEEEE);
        this.method_74308(0.25f);
    }

    public void method_3070() {
        if (this.source == null || this.source.isSourceRemoved()) {
            this.method_3085();
            return;
        }
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        } else {
            double distance;
            AirCurrent airCurrent = this.source.getAirCurrent();
            if (airCurrent == null || !airCurrent.bounds.method_1014(0.25).method_1008(this.field_3874, this.field_3854, this.field_3871)) {
                this.method_3085();
                return;
            }
            class_243 directionVec = class_243.method_24954((class_2382)airCurrent.direction.method_62675());
            class_243 motion = directionVec.method_1021(0.125);
            if (!this.source.getAirCurrent().pushing) {
                motion = motion.method_1021(-1.0);
            }
            if ((distance = new class_243(this.field_3874, this.field_3854, this.field_3871).method_1020(VecHelper.getCenterOf((class_2382)this.source.getAirCurrentPos())).method_18806(directionVec).method_1033() - 0.5) > (double)(airCurrent.maxDistance + 1.0f) || distance < -0.25) {
                this.method_3085();
                return;
            }
            motion = motion.method_1021((double)airCurrent.maxDistance - (distance - 1.0)).method_1021(0.5);
            FanProcessingType type = this.getType(distance);
            if (type == null) {
                this.method_3093(0xEEEEEE);
                this.method_74308(0.25f);
                this.selectSprite((int)class_3532.method_15350((double)(distance / (double)airCurrent.maxDistance * 8.0 + (double)this.field_3840.method_43048(4)), (double)0.0, (double)7.0));
            } else {
                type.morphAirFlow(this.access, this.field_3840);
                this.selectSprite(this.field_3840.method_43048(3));
            }
            this.field_3852 = motion.field_1352;
            this.field_3869 = motion.field_1351;
            this.field_3850 = motion.field_1350;
            if (this.field_3845) {
                this.field_3852 *= 0.7;
                this.field_3850 *= 0.7;
            }
            this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        }
    }

    @Nullable
    private FanProcessingType getType(double distance) {
        if (this.source.getAirCurrent() == null) {
            return null;
        }
        return this.source.getAirCurrent().getTypeAt((float)distance);
    }

    public int method_3068(float partialTick) {
        class_2338 blockpos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        return this.field_3851.method_8477(blockpos) ? class_761.method_23794((class_1920)this.field_3851, (class_2338)blockpos) : 0;
    }

    private void selectSprite(int index) {
        this.method_74307(this.field_17866.method_18138(index, 8));
    }

    @Environment(value=EnvType.CLIENT)
    private class Access
    implements FanProcessingType.AirFlowParticleAccess {
        private Access() {
        }

        @Override
        public void setColor(int color) {
            AirFlowParticle.this.method_3093(color);
        }

        @Override
        public void setAlpha(float alpha) {
            AirFlowParticle.this.method_74308(alpha);
        }

        @Override
        public void spawnExtraParticle(class_2394 options, float speedMultiplier) {
            AirFlowParticle.this.field_3851.method_8406(options, AirFlowParticle.this.field_3874, AirFlowParticle.this.field_3854, AirFlowParticle.this.field_3871, AirFlowParticle.this.field_3852 * (double)speedMultiplier, AirFlowParticle.this.field_3869 * (double)speedMultiplier, AirFlowParticle.this.field_3850 * (double)speedMultiplier);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<AirFlowParticleData> {
        private final class_4002 spriteSet;

        public Factory(class_4002 animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public class_703 createParticle(AirFlowParticleData data, class_638 worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_5819 random) {
            class_2586 be = worldIn.method_8321(new class_2338(data.posX(), data.posY(), data.posZ()));
            if (!(be instanceof IAirCurrentSource)) {
                be = null;
            }
            return new AirFlowParticle(worldIn, (IAirCurrentSource)be, x, y, z, this.spriteSet, random);
        }
    }
}

